/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import io.micrometer.core.instrument.Meter;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.plugin.MetricsPluginTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class JvmMetricsTest
extends ActiveMQTestBase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testJvmMemoryMetricsPositive() throws Exception {
        this.internalTestMetrics(true, true, false, false, "jvm.memory");
    }

    @Test
    public void testJvmMemoryMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, "jvm.memory");
    }

    @Test
    public void testJvmGcMetricsPositive() throws Exception {
        this.internalTestMetrics(true, false, true, false, "jvm.gc");
    }

    @Test
    public void testJvmGcMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, "jvm.gc");
    }

    @Test
    public void testJvmThreadMetricsPositive() throws Exception {
        this.internalTestMetrics(true, false, false, true, "jvm.thread");
    }

    @Test
    public void testJvmThreadMetricsNegative() throws Exception {
        this.internalTestMetrics(false, false, false, false, "jvm.thread");
    }

    private void internalTestMetrics(boolean found, boolean memory, boolean gc, boolean thread, String match) throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig().setMetricsConfiguration(new MetricsConfiguration().setPlugin(new SimpleMetricsPlugin().init(null)).setJvmMemory(memory).setJvmGc(gc).setJvmThread(thread)));
        server.start();
        boolean result = false;
        for (Meter.Id meterId : MetricsPluginTest.getMetrics(server).keySet()) {
            if (!meterId.getName().startsWith(match)) continue;
            result = true;
            break;
        }
        JvmMetricsTest.assertEquals((Object)found, (Object)result);
    }
}

