/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RejectValidatedUserTest
extends ActiveMQTestBase {
    private static final String ADDRESS = "TestQueue";
    private ActiveMQServer server;

    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.getConfiguration().setRejectEmptyValidatedUser(true);
        this.server.start();
    }

    @Test
    public void testRejectException() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = locator.createSessionFactory();
        ClientSession session = sessionFactory.createSession();
        ClientProducer producer = session.createProducer(ADDRESS);
        try {
            producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQIllegalStateException activeMQIllegalStateException) {
            // empty catch block
        }
        locator.close();
    }

    @Test
    public void testAcceptException() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = locator.createSessionFactory();
        ClientSession session = sessionFactory.createSession();
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        message.setValidatedUserID("testuser");
        producer.send((org.apache.activemq.artemis.api.core.Message)message);
        locator.close();
    }

    @Test
    public void testAcceptJMSException() throws Exception {
        ActiveMQConnectionFactory connectionFactory = ActiveMQJMSClient.createConnectionFactory((String)"vm://0", (String)"0");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession();
        Queue queue = session.createQueue(ADDRESS.toString());
        MessageProducer producer = session.createProducer((Destination)queue);
        Message message = session.createMessage();
        message.setStringProperty("JMSXUserID", "testuser");
        producer.send(message);
    }
}

