/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.ssl.TestTrustManagerFactoryPlugin;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CoreClientOverOneWaySSLTest
extends ActiveMQTestBase {
    String suffix = "";
    public static final SimpleString QUEUE = new SimpleString("QueueOverSSL");
    private boolean generateWarning;
    private String storeProvider;
    private String storeType;
    private String SERVER_SIDE_KEYSTORE;
    private String CLIENT_SIDE_TRUSTSTORE;
    private final String PASSWORD = "securepass";
    private ActiveMQServer server;
    private TransportConfiguration tc;

    @Parameterized.Parameters(name="storeProvider={0}, storeType={1}")
    public static Collection getParameters() {
        return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS", false}, {"SunJCE", "JCEKS", false}, {"SUN", "JKS", false}, {"SunJSSE", "PKCS12", false}, {"JCEKS", null, true}, {"JKS", null, true}, {"PKCS12", null, true});
    }

    public CoreClientOverOneWaySSLTest(String storeProvider, String storeType, boolean generateWarning) {
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        this.generateWarning = generateWarning;
        String string = this.suffix = storeType == null || storeType.length() == 0 ? storeProvider.toLowerCase() : storeType.toLowerCase();
        if (this.suffix.equalsIgnoreCase("PKCS12")) {
            this.suffix = "p12";
        }
        this.SERVER_SIDE_KEYSTORE = "server-keystore." + this.suffix;
        this.CLIENT_SIDE_TRUSTSTORE = "server-ca-truststore." + this.suffix;
    }

    @Before
    public void validateLogging() {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void afterValidateLogging() {
        if (this.generateWarning) {
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ212080"}));
        } else {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ212080"}));
        }
        AssertionLoggerHandler.clear();
    }

    @Test
    public void testOneWaySSL() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithSNI() throws Exception {
        this.createCustomSslServer("myhost\\.com");
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("sniHost", "myhost.com");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithSNINegative() throws Exception {
        this.createCustomSslServer("myhost\\.com");
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("sniHost", "badhost.com");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
            CoreClientOverOneWaySSLTest.fail((String)"Should have failed due to unrecognized SNI host name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOneWaySSLwithSNINegativeAndURL() throws Exception {
        this.createCustomSslServer("myhost\\.com");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)("tcp://127.0.0.1:61616?sslEnabled=true;trustStoreProvider=" + this.storeProvider + ";" + "trustStoreType" + "=" + this.storeType + ";" + "trustStorePath" + "=" + this.CLIENT_SIDE_TRUSTSTORE + ";" + "trustStorePassword" + "=" + "securepass" + ";" + "sniHost" + "=badhost.com")));
        try {
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
            CoreClientOverOneWaySSLTest.fail((String)"Should have failed due to unrecognized SNI host name");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOneWaySSLwithSNIOnlyOnTheClient() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("sniHost", "myhost.com");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithSNIOnlyOnTheBroker() throws Exception {
        this.createCustomSslServer("myhost\\.com");
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithTrustManagerPlugin() throws Exception {
        this.createCustomSslServer(null, null, false, null, TestTrustManagerFactoryPlugin.class.getName());
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        CoreClientOverOneWaySSLTest.assertTrue((boolean)TestTrustManagerFactoryPlugin.triggered.get());
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithURL() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        String url = "tcp://127.0.0.1:61616?sslEnabled=true;trustStorePath=" + this.CLIENT_SIDE_TRUSTSTORE + ";trustStorePassword=" + "securepass";
        if (this.storeProvider != null && !this.storeProvider.equals(TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER)) {
            url = url + ";trustStoreProvider=" + this.storeProvider;
        }
        if (this.storeType != null && !this.storeType.equals("JKS")) {
            url = url + ";trustStoreType=" + this.storeType;
        }
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)url));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithURLandMaskedPasswordProperty() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        DefaultSensitiveStringCodec codec = PasswordMaskingUtil.getDefaultCodec();
        HashMap params = new HashMap();
        codec.init(params);
        String masked = codec.encode((Object)"securepass");
        String url = "tcp://127.0.0.1:61616?sslEnabled=true;trustStorePath=" + this.CLIENT_SIDE_TRUSTSTORE + ";trustStorePassword=" + masked + ";activemq.usemaskedpassword=true";
        if (this.storeProvider != null && !this.storeProvider.equals(TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER)) {
            url = url + ";trustStoreProvider=" + this.storeProvider;
        }
        if (this.storeType != null && !this.storeType.equals("JKS")) {
            url = url + ";trustStoreType=" + this.storeType;
        }
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)url));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLwithURLandMaskedPasswordENCSyntax() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        DefaultSensitiveStringCodec codec = PasswordMaskingUtil.getDefaultCodec();
        HashMap params = new HashMap();
        codec.init(params);
        String masked = codec.encode((Object)"securepass");
        String url = "tcp://127.0.0.1:61616?sslEnabled=true;trustStorePath=" + this.CLIENT_SIDE_TRUSTSTORE + ";trustStorePassword=ENC(" + masked + ")";
        if (this.storeProvider != null && !this.storeProvider.equals(TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER)) {
            url = url + ";trustStoreProvider=" + this.storeProvider;
        }
        if (this.storeType != null && !this.storeType.equals("JKS")) {
            url = url + ";trustStoreType=" + this.storeType;
        }
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)url));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLUsingDefaultSslContext() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("useDefaultSslContext", true);
        Pair compat = SSLSupport.getValidProviderAndType((String)this.storeProvider, (String)this.storeType);
        SSLContext.setDefault(new SSLSupport().setTruststoreProvider((String)compat.getA()).setTruststoreType((String)compat.getB()).setTruststorePath(this.CLIENT_SIDE_TRUSTSTORE).setTruststorePassword("securepass").createContext());
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLVerifyHost() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("verifyHost", true);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLVerifyHostNegative() throws Exception {
        this.createCustomSslServer(true);
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("verifyHost", true);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
            CoreClientOverOneWaySSLTest.fail((String)"Creating a session here should fail due to a certificate with a CN that doesn't match the host name.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOneWaySSLReloaded() throws Exception {
        this.createCustomSslServer();
        this.server.createQueue(new QueueConfiguration(QUEUE).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator existingLocator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        existingLocator.setCallTimeout(3000L);
        ClientSessionFactory existingSessionFactory = this.addSessionFactory(this.createSessionFactory(existingLocator));
        ClientSession existingSession = this.addClientSession(existingSessionFactory.createSession(false, true, true));
        ClientConsumer existingConsumer = this.addClientConsumer(existingSession.createConsumer(QUEUE));
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", "other-server-truststore." + this.suffix);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc})).setCallTimeout(3000L);
        try {
            this.addSessionFactory(this.createSessionFactory(locator));
            CoreClientOverOneWaySSLTest.fail((String)"Creating session here should fail due to SSL handshake problems.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("nettySSL");
        acceptor.setKeyStorePath("other-" + this.SERVER_SIDE_KEYSTORE);
        acceptor.reload();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer(QUEUE));
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(QUEUE));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
        consumer.close();
        existingSession.start();
        m = existingConsumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLWithBadClientCipherSuite() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledCipherSuites", "myBadCipherSuite");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithBadServerCipherSuite() throws Exception {
        this.createCustomSslServer("myBadCipherSuite", null);
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithMismatchedCipherSuites() throws Exception {
        this.createCustomSslServer(this.getEnabledCipherSuites()[0], "TLSv1.2");
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledCipherSuites", this.getEnabledCipherSuites()[1]);
        this.tc.getParams().put("enabledProtocols", "TLSv1.2");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithBadClientProtocol() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledProtocols", "myBadProtocol");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithBadServerProtocol() throws Exception {
        this.createCustomSslServer(null, "myBadProtocol");
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithMismatchedProtocols() throws Exception {
        this.createCustomSslServer(null, "TLSv1");
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledProtocols", "TLSv1.2");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testPOODLE() throws Exception {
        this.createCustomSslServer(null, "SSLv3");
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledProtocols", "SSLv3");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOneWaySSLWithGoodClientCipherSuite() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledCipherSuites", this.getSuitableCipherSuite());
        this.tc.getParams().put("enabledProtocols", "TLSv1.2");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = null;
        try {
            sf = this.createSessionFactory(locator);
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.fail();
        }
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLWithGoodServerCipherSuite() throws Exception {
        this.createCustomSslServer(this.getSuitableCipherSuite(), null);
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledProtocols", "TLSv1.2");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = null;
        try {
            sf = this.createSessionFactory(locator);
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.fail();
        }
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLWithGoodClientProtocol() throws Exception {
        this.createCustomSslServer();
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        this.tc.getParams().put("enabledProtocols", "TLSv1.2");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = null;
        try {
            sf = this.createSessionFactory(locator);
            Assert.assertTrue((boolean)true);
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.fail();
        }
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    @Test
    public void testOneWaySSLWithGoodServerProtocol() throws Exception {
        this.createCustomSslServer(null, "TLSv1.2");
        String text = RandomUtil.randomString();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        ClientSessionFactory sf = null;
        try {
            sf = this.createSessionFactory(locator);
            Assert.assertTrue((boolean)true);
        }
        catch (ActiveMQNotConnectedException e) {
            Assert.fail();
        }
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        ClientMessage message = this.createTextMessage(session, text);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)text, (Object)m.getBodyBuffer().readString());
    }

    public String getSuitableCipherSuite() throws Exception {
        String result = "";
        String[] suites = this.getEnabledCipherSuites();
        for (int i = 0; i < suites.length; ++i) {
            String suite = suites[i];
            String storeType = (String)SSLSupport.getValidProviderAndType((String)this.storeProvider, (String)this.storeType).getB();
            if (storeType == null || (!storeType.equals("JCEKS") || !suite.contains("RSA") || suite.contains("ECDH_")) && (storeType.equals("JCEKS") || suite.contains("ECDSA") || !suite.contains("RSA"))) continue;
            result = suite;
            break;
        }
        return result;
    }

    public String[] getEnabledCipherSuites() throws Exception {
        Pair compat = SSLSupport.getValidProviderAndType((String)this.storeProvider, (String)this.storeType);
        SSLContext context = new SSLSupport().setKeystoreProvider((String)compat.getA()).setKeystoreType((String)compat.getB()).setKeystorePath(this.SERVER_SIDE_KEYSTORE).setKeystorePassword("securepass").setTruststoreProvider((String)compat.getA()).setTruststoreType((String)compat.getB()).setTruststorePath(this.CLIENT_SIDE_TRUSTSTORE).setTruststorePassword("securepass").createContext();
        SSLEngine engine = context.createSSLEngine();
        return engine.getEnabledCipherSuites();
    }

    @Test
    public void testOneWaySSLWithoutTrustStore() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", true);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
        }
        catch (ActiveMQException e) {
            CoreClientOverOneWaySSLTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testOneWaySSLWithIncorrectTrustStorePassword() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStoreProvider", this.storeProvider);
        this.tc.getParams().put("trustStoreType", this.storeType);
        this.tc.getParams().put("trustStorePath", this.CLIENT_SIDE_TRUSTSTORE);
        this.tc.getParams().put("trustStorePassword", "invalid password");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException sf) {
        }
        catch (ActiveMQException e) {
            CoreClientOverOneWaySSLTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testOneWaySSLWithIncorrectTrustStorePath() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", true);
        this.tc.getParams().put("trustStorePath", "incorrect path");
        this.tc.getParams().put("trustStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc}));
        try {
            ClientSessionFactory sf = this.createSessionFactory(locator);
            Assert.fail();
        }
        catch (ActiveMQNotConnectedException sf) {
        }
        catch (ActiveMQException e) {
            CoreClientOverOneWaySSLTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testPlainConnectionToSSLEndpoint() throws Exception {
        this.createCustomSslServer();
        this.tc.getParams().put("sslEnabled", false);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{this.tc})).setCallTimeout(2000L);
        try {
            this.createSessionFactory(locator);
            CoreClientOverOneWaySSLTest.fail((String)"expecting exception");
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
        }
        catch (ActiveMQConnectionTimedOutException activeMQConnectionTimedOutException) {
        }
        catch (ActiveMQException e) {
            CoreClientOverOneWaySSLTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    private void createCustomSslServer() throws Exception {
        this.createCustomSslServer(null, null);
    }

    private void createCustomSslServer(String cipherSuites, String protocols) throws Exception {
        this.createCustomSslServer(cipherSuites, protocols, false, null);
    }

    private void createCustomSslServer(String sniHost) throws Exception {
        this.createCustomSslServer(null, null, false, sniHost);
    }

    private void createCustomSslServer(boolean useUnknownKeystore) throws Exception {
        this.createCustomSslServer(null, null, useUnknownKeystore, null);
    }

    private void createCustomSslServer(String cipherSuites, String protocols, boolean useUnknownKeystore, String sniHost) throws Exception {
        this.createCustomSslServer(cipherSuites, protocols, useUnknownKeystore, sniHost, null);
    }

    private void createCustomSslServer(String cipherSuites, String protocols, boolean useUnknownKeystore, String sniHost, String trustManagerFactoryPlugin) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStoreProvider", this.storeProvider);
        params.put("keyStoreType", this.storeType);
        if (sniHost != null) {
            params.put("sniHost", sniHost);
        }
        if (useUnknownKeystore) {
            params.put("keyStorePath", "unknown-" + this.SERVER_SIDE_KEYSTORE);
        } else {
            params.put("keyStorePath", this.SERVER_SIDE_KEYSTORE);
        }
        params.put("keyStorePassword", "securepass");
        params.put("host", "localhost");
        if (cipherSuites != null) {
            params.put("enabledCipherSuites", cipherSuites);
        }
        if (protocols != null) {
            params.put("enabledProtocols", protocols);
        }
        if (trustManagerFactoryPlugin != null) {
            params.put("trustManagerFactoryPlugin", trustManagerFactoryPlugin);
        }
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
        this.waitForServerToStart(this.server);
        this.tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
    }
}

