/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.MetricResolver;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.setup.MetricsMetadata;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@Interceptor
@MetricsBinding
@Priority(value=1000)
public class GaugeRegistrationInterceptor {
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    GaugeRegistrationInterceptor(MetricRegistry registry) {
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    Object metrics(InvocationContext context) throws Exception {
        Class type = context.getConstructor().getDeclaringClass();
        Object target = context.proceed();
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<Method> memberInfoAdapter = new CDIMemberInfoAdapter<Method>();
        do {
            for (Method method : type.getDeclaredMethods()) {
                MetricResolver.Of<org.eclipse.microprofile.metrics.annotation.Gauge> gauge = this.resolver.gauge(beanInfoAdapter.convert(type), memberInfoAdapter.convert(method));
                if (!gauge.isPresent()) continue;
                AnnotationInfo g = gauge.metricAnnotation();
                Metadata metadata = MetricsMetadata.getMetadata(g, gauge.metricName(), g.unit(), g.description(), g.displayName(), MetricType.GAUGE);
                this.registry.register(metadata, (Metric)new ForwardingGauge(method, context.getTarget()), TagsUtils.parseTagsAsArray(g.tags()));
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static final class ForwardingGauge
    implements Gauge<Number> {
        private final Method method;
        private final Object object;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Number getValue() {
            return (Number)GaugeRegistrationInterceptor.invokeMethod(this.method, this.object);
        }
    }
}

