/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.EjbProviderRequirement;
import org.wildfly.extension.clustering.ejb.DistributableEjbResourceDefinition;

public class DistributableEjbResourceServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        String defaultBeanManagement = DistributableEjbResourceDefinition.Attribute.DEFAULT_BEAN_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        new IdentityCapabilityServiceConfigurator(DistributableEjbResourceDefinition.Capability.DEFAULT_BEAN_MANAGEMENT_PROVIDER.getServiceName(address), (UnaryServiceNameFactory)EjbProviderRequirement.BEAN_MANAGEMENT_PROVIDER, defaultBeanManagement).configure(context).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (DistributableEjbResourceDefinition.Capability capability : EnumSet.allOf(DistributableEjbResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
    }
}

