/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.XMLLocation;

final class BasicXMLStreamReader
implements ConfigurationXMLStreamReader {
    private final XMLLocation includedFrom;
    private final XMLStreamReader xmlStreamReader;
    private final URI uri;
    private final XMLInputFactory inputFactory;
    private final Closeable underlying;

    BasicXMLStreamReader(XMLLocation includedFrom, XMLStreamReader xmlStreamReader, URI uri, XMLInputFactory inputFactory, Closeable underlying) {
        this.includedFrom = includedFrom;
        this.xmlStreamReader = xmlStreamReader;
        this.uri = uri;
        this.inputFactory = inputFactory;
        this.underlying = underlying;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public XMLInputFactory getXmlInputFactory() {
        return this.inputFactory;
    }

    @Override
    public XMLLocation getIncludedFrom() {
        return this.includedFrom;
    }

    @Override
    public boolean hasNext() throws ConfigXMLParseException {
        try {
            return this.xmlStreamReader.hasNext();
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public int next() throws ConfigXMLParseException {
        try {
            return this.xmlStreamReader.next();
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws ConfigXMLParseException {
        try {
            this.xmlStreamReader.require(type, namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public String getElementText() throws ConfigXMLParseException {
        try {
            return this.xmlStreamReader.getElementText();
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public int nextTag() throws ConfigXMLParseException {
        try {
            return this.xmlStreamReader.nextTag();
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public XMLLocation getLocation() {
        return new XMLLocation(this.includedFrom, this.uri, this.xmlStreamReader.getLocation());
    }

    @Override
    public QName getName() {
        return this.xmlStreamReader.getName();
    }

    @Override
    public String getLocalName() {
        return this.xmlStreamReader.getLocalName();
    }

    @Override
    public boolean hasName() {
        return this.xmlStreamReader.hasName();
    }

    @Override
    public String getNamespaceURI() {
        return this.xmlStreamReader.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.xmlStreamReader.getPrefix();
    }

    @Override
    public String getVersion() {
        return this.xmlStreamReader.getVersion();
    }

    @Override
    public boolean isStandalone() {
        return this.xmlStreamReader.isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        return this.xmlStreamReader.standaloneSet();
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.xmlStreamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getPITarget() {
        return this.xmlStreamReader.getPITarget();
    }

    @Override
    public String getPIData() {
        return this.xmlStreamReader.getPIData();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws ConfigXMLParseException {
        try {
            return this.xmlStreamReader.getTextCharacters(sourceStart, target, targetStart, length);
        }
        catch (XMLStreamException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public int getTextStart() {
        return this.xmlStreamReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.xmlStreamReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return this.xmlStreamReader.getEncoding();
    }

    @Override
    public boolean hasText() {
        return this.xmlStreamReader.hasText();
    }

    @Override
    public void close() throws ConfigXMLParseException {
        try (Closeable underlying = this.underlying;){
            try {
                this.xmlStreamReader.close();
            }
            catch (XMLStreamException e) {
                throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
            }
        }
        catch (IOException e) {
            throw ConfigXMLParseException.from(e, this.uri, this.includedFrom);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.xmlStreamReader.getNamespaceURI(prefix);
    }

    @Override
    public boolean isWhiteSpace() {
        return this.xmlStreamReader.isWhiteSpace();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.xmlStreamReader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.xmlStreamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.xmlStreamReader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.xmlStreamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.xmlStreamReader.getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.xmlStreamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.xmlStreamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.xmlStreamReader.getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.xmlStreamReader.isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return this.xmlStreamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.xmlStreamReader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.xmlStreamReader.getNamespaceURI(index);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xmlStreamReader.getNamespaceContext();
    }

    @Override
    public int getEventType() {
        return this.xmlStreamReader.getEventType();
    }

    @Override
    public String getText() {
        return this.xmlStreamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.xmlStreamReader.getTextCharacters();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.xmlStreamReader.getProperty(name);
    }
}

