/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.contexts;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class PassivationCapableSerializableMarshaller<SC extends SerializableContextual<C, I> & PassivationCapable, C extends Contextual<I> & PassivationCapable, I>
implements ProtoStreamMarshaller<SC> {
    private static final int CONTEXT_INDEX = 1;
    private static final int CONTEXTUAL_INDEX = 2;
    private static final int IDENTIFIER_INDEX = 3;
    private final Class<SC> targetClass;
    private final BiFunction<String, C, SC> factory;
    private final Function<SC, String> contextFunction;

    PassivationCapableSerializableMarshaller(Class<SC> targetClass, BiFunction<String, C, SC> factory, Function<SC, String> contextFunction) {
        this.targetClass = targetClass;
        this.factory = factory;
        this.contextFunction = contextFunction;
    }

    public Class<SC> getJavaClass() {
        return this.targetClass;
    }

    public SC readFrom(ProtoStreamReader reader) throws IOException {
        String contextId = null;
        Contextual contextual = null;
        String identifier = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    contextId = (String)reader.readAny(String.class);
                    continue block5;
                }
                case 2: {
                    contextual = (Contextual)reader.readAny();
                    continue block5;
                }
                case 3: {
                    identifier = (String)reader.readAny(String.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        if (contextual == null) {
            contextual = ((ContextualStore)Container.instance(contextId).services().get(ContextualStore.class)).getContextual(identifier);
        }
        return (SC)((SerializableContextual)this.factory.apply(contextId, contextual));
    }

    public void writeTo(ProtoStreamWriter writer, SC contextual) throws IOException {
        writer.writeAny(1, (Object)this.contextFunction.apply(contextual));
        if (writer.getSerializationContext().canMarshall((Object)contextual.get())) {
            writer.writeAny(2, (Object)contextual.get());
        } else {
            writer.writeAny(3, (Object)((PassivationCapable)contextual).getId());
        }
    }
}

