/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.List;
import org.hibernate.cache.internal.CacheKeyValueDescriptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.type.descriptor.java.JavaType;

public class ComponentCacheKeyValueDescriptor
implements CacheKeyValueDescriptor {
    private final NavigableRole role;
    private final SessionFactoryImplementor sessionFactory;
    private transient EmbeddableValuedModelPart embeddedMapping;

    public ComponentCacheKeyValueDescriptor(NavigableRole role, SessionFactoryImplementor sessionFactory) {
        this.role = role;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public int getHashCode(Object key) {
        List<AttributeMapping> attrs = this.getEmbeddedMapping().getEmbeddableTypeDescriptor().getAttributeMappings();
        int result = 17;
        for (int i = 0; i < attrs.size(); ++i) {
            AttributeMapping attr = attrs.get(i);
            Object attrValue = this.getAttributeValue(key, i, attr);
            result *= 37;
            if (attrValue == null) continue;
            JavaType<?> javaType = attr.getJavaType();
            result += javaType.extractHashCode(attrValue);
        }
        return result;
    }

    @Override
    public boolean isEqual(Object key1, Object key2) {
        if (key1 == key2) {
            return true;
        }
        List<AttributeMapping> attrs = this.getEmbeddedMapping().getEmbeddableTypeDescriptor().getAttributeMappings();
        for (int i = 0; i < attrs.size(); ++i) {
            AttributeMapping attr = attrs.get(i);
            Object value1 = this.getAttributeValue(key1, i, attr);
            Object value2 = this.getAttributeValue(key2, i, attr);
            JavaType<?> javaType = attr.getJavaType();
            if (javaType.areEqual(value1, value2)) continue;
            return false;
        }
        return true;
    }

    public Object getAttributeValue(Object component, int i, AttributeMapping attr) {
        if (component instanceof Object[]) {
            return ((Object[])component)[i];
        }
        return attr.getValue(component);
    }

    private EmbeddableValuedModelPart getEmbeddedMapping() {
        if (this.embeddedMapping == null) {
            this.embeddedMapping = this.sessionFactory.getRuntimeMetamodels().getEmbedded(this.role);
        }
        return this.embeddedMapping;
    }
}

