/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class QualifiedJoinPredicatePathConsumer
extends BasicDotIdentifierConsumer {
    private final SqmQualifiedJoin<?, ?> sqmJoin;

    public QualifiedJoinPredicatePathConsumer(SqmQualifiedJoin<?, ?> sqmJoin, SqmCreationState creationState) {
        super(creationState);
        this.sqmJoin = sqmJoin;
    }

    @Override
    protected SemanticPathPart createBasePart() {
        return new BasicDotIdentifierConsumer.BaseLocalSequencePart(){

            @Override
            protected void validateAsRoot(SqmFrom<?, ?> pathRoot) {
                SqmRoot<?> joinRoot;
                SqmRoot<?> root = pathRoot.findRoot();
                if (root != (joinRoot = QualifiedJoinPredicatePathConsumer.this.sqmJoin.findRoot())) {
                    JpaQueryStructure querySpec;
                    SqmFromClause fromClause;
                    SqmCreationProcessingState processingState = QualifiedJoinPredicatePathConsumer.this.getCreationState().getCurrentProcessingState();
                    SqmQuery<?> currentProcessingQuery = processingState.getProcessingQuery();
                    if (currentProcessingQuery instanceof SqmSelectQuery && (fromClause = ((SqmQuerySpec)(querySpec = ((SqmSelectQuery)currentProcessingQuery).getQuerySpec())).getFromClause()) != null && fromClause.getRoots().contains(joinRoot)) {
                        if (!(root instanceof SqmCorrelation) || !fromClause.getRoots().contains(root)) {
                            this.validateAsRootOnParentQueryClosure(pathRoot, root, processingState.getParentProcessingState());
                        }
                        return;
                    }
                    if (currentProcessingQuery instanceof SqmSubQuery) {
                        this.validateAsRootOnParentQueryClosure(pathRoot, root, processingState);
                        return;
                    }
                    throw new SemanticException(String.format(Locale.ROOT, "SqmQualifiedJoin predicate referred to SqmRoot [`%s`] other than the join's root [`%s`]", pathRoot.getNavigablePath(), QualifiedJoinPredicatePathConsumer.this.sqmJoin.getNavigablePath()));
                }
                super.validateAsRoot(pathRoot);
            }

            private void validateAsRootOnParentQueryClosure(SqmFrom<?, ?> pathRoot, SqmRoot<?> root, SqmCreationProcessingState processingState) {
                while (processingState != null) {
                    JpaQueryStructure querySpec;
                    SqmFromClause fromClause;
                    SqmQuery<?> processingQuery = processingState.getProcessingQuery();
                    if (processingQuery instanceof SqmSelectQuery && (fromClause = ((SqmQuerySpec)(querySpec = ((SqmSelectQuery)processingQuery).getQuerySpec())).getFromClause()) != null && fromClause.getRoots().contains(root)) {
                        super.validateAsRoot(pathRoot);
                        return;
                    }
                    processingState = processingState.getParentProcessingState();
                }
                throw new SemanticException(String.format(Locale.ROOT, "SqmQualifiedJoin predicate referred to SqmRoot [`%s`] other than the join's root [`%s`]", pathRoot.getNavigablePath(), QualifiedJoinPredicatePathConsumer.this.sqmJoin.getNavigablePath()));
            }
        };
    }
}

