/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm;

import org.hibernate.query.sqm.NullOrdering;
import org.hibernate.query.sqm.SortOrder;

public enum NullPrecedence {
    NONE{

        @Override
        public boolean isDefaultOrdering(SortOrder sortOrder, NullOrdering nullOrdering) {
            return true;
        }
    }
    ,
    FIRST{

        @Override
        public boolean isDefaultOrdering(SortOrder sortOrder, NullOrdering nullOrdering) {
            switch (nullOrdering) {
                case FIRST: {
                    return true;
                }
                case SMALLEST: {
                    return sortOrder == SortOrder.ASCENDING;
                }
                case GREATEST: {
                    return sortOrder == SortOrder.DESCENDING;
                }
            }
            return false;
        }
    }
    ,
    LAST{

        @Override
        public boolean isDefaultOrdering(SortOrder sortOrder, NullOrdering nullOrdering) {
            switch (nullOrdering) {
                case LAST: {
                    return true;
                }
                case SMALLEST: {
                    return sortOrder == SortOrder.DESCENDING;
                }
                case GREATEST: {
                    return sortOrder == SortOrder.ASCENDING;
                }
            }
            return false;
        }
    };


    public abstract boolean isDefaultOrdering(SortOrder var1, NullOrdering var2);

    public static NullPrecedence parse(String name) {
        if ("none".equalsIgnoreCase(name)) {
            return NONE;
        }
        if ("first".equalsIgnoreCase(name)) {
            return FIRST;
        }
        if ("last".equalsIgnoreCase(name)) {
            return LAST;
        }
        return null;
    }

    public static NullPrecedence parse(String name, NullPrecedence defaultValue) {
        NullPrecedence value = NullPrecedence.parse(name);
        return value != null ? value : defaultValue;
    }
}

