/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class UpdateExecutionDelegate
implements TableBasedUpdateHandler.ExecutionDelegate {
    private final SqmUpdateStatement<?> sqmUpdate;
    private final MultiTableSqmMutationConverter sqmConverter;
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final TableGroup updatingTableGroup;
    private final Predicate suppliedPredicate;
    private final EntityMappingType entityDescriptor;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final Map<TableReference, List<Assignment>> assignmentsByTable;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions;
    private final SessionFactoryImplementor sessionFactory;

    public UpdateExecutionDelegate(SqmUpdateStatement<?> sqmUpdate, MultiTableSqmMutationConverter sqmConverter, TemporaryTable idTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainParameterXref domainParameterXref, TableGroup updatingTableGroup, TableReference hierarchyRootTableReference, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, Predicate suppliedPredicate, Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, DomainQueryExecutionContext executionContext) {
        this.sqmUpdate = sqmUpdate;
        this.sqmConverter = sqmConverter;
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        this.updatingTableGroup = updatingTableGroup;
        this.suppliedPredicate = suppliedPredicate;
        this.paramTypeResolutions = paramTypeResolutions;
        this.sessionFactory = executionContext.getSession().getFactory();
        ModelPartContainer updatingModelPart = updatingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        this.entityDescriptor = (EntityMappingType)updatingModelPart;
        this.assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, () -> parameterResolutions), this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> updatingTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + assignment.getAssignable());
                }
                assignmentTableReference = tableReference;
            }
            List<Assignment> assignmentsForTable = this.assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                this.assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(ExecutionContext executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, executionContext);
        try {
            int rows = ExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.sqmConverter, this.suppliedPredicate, this.idTable, this.sessionUidAccess, this.jdbcParameterBindings, executionContext);
            QuerySpec idTableSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.idTable, this.sessionUidAccess, this.entityDescriptor, executionContext);
            this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.updateTable(tableExpression, tableKeyColumnVisitationSupplier, rows, idTableSubQuery, executionContext));
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.afterUseAction, executionContext);
        }
    }

    private TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + columnReference);
    }

    private NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional(), this.sessionFactory);
        }
        return (NamedTableReference)tableReference;
    }

    private void updateTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, int expectedUpdateCount, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        TableReference updatingTableReference = this.updatingTableGroup.getTableReference(this.updatingTableGroup.getNavigablePath(), tableExpression, true, true);
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            keyColumnCollector.apply(new ColumnReference((String)null, selection, this.sessionFactory));
        });
        Expression keyExpression = keyColumnCollector.buildKeyExpression();
        InSubQueryPredicate idTableSubQueryPredicate = new InSubQueryPredicate(keyExpression, idTableSubQuery, false);
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        UpdateStatement sqlAst = new UpdateStatement(dmlTableReference, assignments, idTableSubQueryPredicate);
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcUpdate jdbcUpdate = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory, sqlAst).translate(this.jdbcParameterBindings, executionContext.getQueryOptions());
        int updateCount = jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, this.jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
        if (updateCount == expectedUpdateCount) {
            return;
        }
        AbstractEntityPersister entityPersister = (AbstractEntityPersister)this.entityDescriptor.getEntityPersister();
        boolean isNullable = false;
        for (int i = 0; i < entityPersister.getTableSpan(); ++i) {
            if (!tableExpression.equals(entityPersister.getTableName(i)) || !entityPersister.isNullableTable(i)) continue;
            isNullable = true;
            break;
        }
        if (isNullable) {
            QuerySpec querySpec = new QuerySpec(true);
            for (TableGroup root : idTableSubQuery.getFromClause().getRoots()) {
                querySpec.getFromClause().addRoot(root);
            }
            for (SqlSelection sqlSelection : idTableSubQuery.getSelectClause().getSqlSelections()) {
                querySpec.getSelectClause().addSqlSelection(sqlSelection);
            }
            querySpec.applyPredicate(idTableSubQuery.getWhereClauseRestrictions());
            QuerySpec existsQuerySpec = new QuerySpec(false);
            existsQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(-1, 0, new QueryLiteral<Integer>(1, this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class))));
            NamedTableReference existsTableReference = new NamedTableReference(tableExpression, "dml_", false, this.sessionFactory);
            existsQuerySpec.getFromClause().addRoot(new TableGroupImpl(null, null, existsTableReference, entityPersister));
            TableKeyExpressionCollector existsKeyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
            tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
                assert (selection.getContainingTableExpression().equals(tableExpression));
                existsKeyColumnCollector.apply(new ColumnReference(existsTableReference, selection, this.sessionFactory));
            });
            existsQuerySpec.applyPredicate(new ComparisonPredicate(existsKeyColumnCollector.buildKeyExpression(), ComparisonOperator.EQUAL, this.asExpression(idTableSubQuery.getSelectClause())));
            querySpec.applyPredicate(new ExistsPredicate(existsQuerySpec, true, this.sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class)));
            ArrayList<? extends Expression> targetColumnReferences = new ArrayList<Expression>();
            if (keyExpression instanceof SqlTuple) {
                targetColumnReferences.addAll(((SqlTuple)keyExpression).getExpressions());
            } else {
                targetColumnReferences.add((ColumnReference)keyExpression);
            }
            for (Assignment assignment : assignments) {
                targetColumnReferences.addAll(assignment.getAssignable().getColumnReferences());
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(0, -1, assignment.getAssignedValue()));
            }
            InsertStatement insertSqlAst = new InsertStatement(dmlTableReference);
            insertSqlAst.addTargetColumnReferences(targetColumnReferences.toArray(new ColumnReference[0]));
            insertSqlAst.setSourceSelectStatement(querySpec);
            JdbcInsert jdbcInsert = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildInsertTranslator(this.sessionFactory, insertSqlAst).translate(this.jdbcParameterBindings, executionContext.getQueryOptions());
            int insertCount = jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, this.jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
            assert (insertCount + updateCount == expectedUpdateCount);
        }
    }

    private Expression asExpression(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        if (sqlSelections.size() == 1) {
            return sqlSelections.get(0).getExpression();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(sqlSelections.size());
        for (SqlSelection sqlSelection : sqlSelections) {
            expressions.add(sqlSelection.getExpression());
        }
        return new SqlTuple(expressions, null);
    }
}

