/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;

public class SqmTreatedSimplePath<T, S extends T>
extends SqmEntityValuedSimplePath<S>
implements SqmSimplePath<S>,
SqmTreatedPath<T, S> {
    private final EntityDomainType<S> treatTarget;
    private final SqmPath<T> wrappedPath;

    public SqmTreatedSimplePath(SqmPluralValuedSimplePath<T> wrappedPath, EntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), (EntityDomainType)wrappedPath.getReferencedPathSource(), (SqmPath<?>)wrappedPath.getLhs(), nodeBuilder);
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    public SqmTreatedSimplePath(SqmPath<T> wrappedPath, EntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), (EntityDomainType)wrappedPath.getReferencedPathSource(), (SqmPath<?>)wrappedPath.getLhs(), nodeBuilder);
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedSimplePath<T, S> copy(SqmCopyContext context) {
        SqmTreatedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedSimplePath<T, S> path = context.registerCopy(this, new SqmTreatedSimplePath<T, S>(this.wrappedPath.copy(context), this.getTreatTarget(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public <S1 extends S> SqmTreatedSimplePath<S, S1> treatAs(Class<S1> treatJavaType) throws PathException {
        return super.treatAs(treatJavaType);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

