/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;

public class JacksonXmlFormatMapper
implements FormatMapper {
    public static final String SHORT_NAME = "jackson-xml";
    public static final JacksonXmlFormatMapper INSTANCE = new JacksonXmlFormatMapper();
    private final ObjectMapper objectMapper;

    public JacksonXmlFormatMapper() {
        this((ObjectMapper)new XmlMapper());
    }

    public JacksonXmlFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(javaType.getJavaType()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + javaType, e);
        }
    }

    @Override
    public <T> String toString(T value, JavaType<T> javaType, WrapperOptions wrapperOptions) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(javaType.getJavaType())).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + javaType, e);
        }
    }
}

