/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class DateJdbcType
implements JdbcType {
    public static final DateJdbcType INSTANCE = new DateJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 91;
    }

    @Override
    public String getFriendlyName() {
        return "DATE";
    }

    public String toString() {
        return "DateTypeDescriptor";
    }

    @Override
    public <T> BasicJavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Date.class));
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.DATE);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Date date = javaType.unwrap(value, Date.class, options);
                if (value instanceof Calendar) {
                    st.setDate(index, date, (Calendar)value);
                } else {
                    st.setDate(index, date);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Date date = javaType.unwrap(value, Date.class, options);
                if (value instanceof Calendar) {
                    st.setDate(name, date, (Calendar)value);
                } else {
                    st.setDate(name, date);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap(rs.getDate(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getDate(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap(statement.getDate(name), options);
            }
        };
    }
}

