/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.io.File;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class ReportDirectoryWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition attributeDefinition;

    ReportDirectoryWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateReportDirectory(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateReportDirectory(context, restored);
    }

    void updateReportDirectory(OperationContext context, ModelNode model) throws OperationFailedException {
        String reportDirectoryName = this.attributeDefinition.resolveModelAttribute(context, model).asString();
        File reportDirectory = new File(reportDirectoryName);
        if (!reportDirectory.exists()) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.reportDirectoryDoesNotExist(reportDirectoryName);
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController ejbNameServiceController = registry.getService(ConnectorServices.RESOURCEADAPTERS_SUBSYSTEM_SERVICE);
        ResourceAdaptersSubsystemService service = (ResourceAdaptersSubsystemService)ejbNameServiceController.getValue();
        service.setReportDirectory(reportDirectory);
    }
}

