/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfigImpl
implements OpenApiConfig {
    private Config config;
    private Map<String, Object> cache = new HashMap<String, Object>();
    private Optional<Boolean> allowNakedPathParameter = Optional.empty();

    @Deprecated
    public static OpenApiConfig fromConfig(Config config) {
        return new OpenApiConfigImpl(config);
    }

    public OpenApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    protected Iterable<String> getPropertyNames() {
        return this.getConfig().getPropertyNames();
    }

    protected <T> T getValue(String propertyName, Class<T> type) {
        return (T)this.getConfig().getValue(propertyName, type);
    }

    protected <T> Optional<T> getOptionalValue(String propertyName, Class<T> type) {
        return this.getConfig().getOptionalValue(propertyName, type);
    }

    @Override
    public Optional<Boolean> allowNakedPathParameter() {
        return this.allowNakedPathParameter;
    }

    @Override
    public void setAllowNakedPathParameter(Boolean allowNakedPathParameter) {
        this.allowNakedPathParameter = Optional.ofNullable(allowNakedPathParameter);
    }

    @Override
    public <R, T> T getConfigValue(String propertyName, Class<R> type, Function<R, T> converter, Supplier<T> defaultValue) {
        if (this.cache.containsKey(propertyName)) {
            return (T)this.cache.get(propertyName);
        }
        T value = this.getOptionalValue(propertyName, type).filter(configValue -> {
            if (String.class.equals((Object)type)) {
                return !configValue.toString().trim().isEmpty();
            }
            return true;
        }).map(converter).orElseGet(defaultValue);
        this.cache.put(propertyName, value);
        return value;
    }

    @Override
    public <R, T> Map<String, T> getConfigValueMap(String propertyNamePrefix, Class<R> type, Function<R, T> converter) {
        if (this.cache.containsKey(propertyNamePrefix)) {
            return (Map)this.cache.get(propertyNamePrefix);
        }
        Map<String, Object> valueMap = StreamSupport.stream(this.getPropertyNames().spliterator(), false).filter(propertyName -> propertyName.startsWith(propertyNamePrefix)).collect(Collectors.toMap(name -> name.substring(propertyNamePrefix.length()), name -> converter.apply(this.getValue((String)name, type))));
        this.cache.put(propertyNamePrefix, valueMap);
        return valueMap;
    }
}

