/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.realm.JaasSecurityRealm;
import org.wildfly.security.auth.server.SecurityRealm;

public class JaasRealmDefinition
extends SimpleResourceDefinition {
    private static final SimpleAttributeDefinition ENTRY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry", ModelType.STRING, false).setRequired(true)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("file")).setRequired(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("file")).setRestartAllServices()).setRequires(new String[]{"path"})).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, false).setRequired(false)).setRestartAllServices()).build();
    private static final SimpleAttributeDefinition CALLBACK_HANDLER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("callback-handler", ModelType.STRING, true).setRequired(false)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ENTRY, PATH, RELATIVE_TO, MODULE, CALLBACK_HANDLER};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    JaasRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"jaas-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("jaas-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler write = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)write);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ClassLoader classLoader;
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            final String jaasConfigPath = PATH.resolveModelAttribute(context, model).asStringOrNull();
            final String relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            String callbackHandlerClassName = CALLBACK_HANDLER.resolveModelAttribute(context, model).asStringOrNull();
            final String entryName = ENTRY.resolveModelAttribute(context, model).asString();
            String module = MODULE.resolveModelAttribute(context, model).asStringOrNull();
            CallbackHandler callbackhandler = null;
            try {
                classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                if (callbackHandlerClassName != null) {
                    Class<?> typeClazz = classLoader.loadClass(callbackHandlerClassName);
                    callbackhandler = (CallbackHandler)typeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.failedToLoadCallbackhandlerFromProvidedModule();
            }
            final InjectedValue pathManagerInjector = new InjectedValue();
            final CallbackHandler finalCallbackHandler = callbackhandler;
            TrivialService<SecurityRealm> jaasRealmService = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){
                private FileAttributeDefinitions.PathResolver pathResolver;

                @Override
                public SecurityRealm get() throws StartException {
                    String rootPath = null;
                    if (jaasConfigPath != null) {
                        this.pathResolver = FileAttributeDefinitions.pathResolver();
                        File jaasConfigFile = this.pathResolver.path(jaasConfigPath).relativeTo(relativeTo, (PathManager)pathManagerInjector.getOptionalValue()).resolve();
                        if (!jaasConfigFile.exists()) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.jaasFileDoesNotExist(jaasConfigFile.getPath());
                        }
                        rootPath = jaasConfigFile.getPath();
                    }
                    return new JaasSecurityRealm(entryName, rootPath, classLoader, finalCallbackHandler);
                }

                @Override
                public void dispose() {
                    if (this.pathResolver != null) {
                        this.pathResolver.clear();
                        this.pathResolver = null;
                    }
                }
            });
            ServiceName realmName = runtimeCapability.getCapabilityServiceName(SecurityRealm.class);
            ServiceBuilder serviceBuilder = serviceTarget.addService(realmName, jaasRealmService);
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                serviceBuilder.requires(FileAttributeDefinitions.pathName(relativeTo));
            }
            ElytronDefinition.commonDependencies(serviceBuilder).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

