/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class JsonNumberImpl
implements JsonNumber {
    private int hashCode;
    private final int bigIntegerScaleLimit;

    JsonNumberImpl(int bigIntegerScaleLimit) {
        this.bigIntegerScaleLimit = bigIntegerScaleLimit;
    }

    static JsonNumber getJsonNumber(int num, int bigIntegerScaleLimit) {
        return new JsonIntNumber(num, bigIntegerScaleLimit);
    }

    static JsonNumber getJsonNumber(long num, int bigIntegerScaleLimit) {
        return new JsonLongNumber(num, bigIntegerScaleLimit);
    }

    static JsonNumber getJsonNumber(BigInteger value, int bigIntegerScaleLimit) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return new JsonBigDecimalNumber(new BigDecimal(value), bigIntegerScaleLimit);
    }

    static JsonNumber getJsonNumber(double value, int bigIntegerScaleLimit) {
        return new JsonBigDecimalNumber(BigDecimal.valueOf(value), bigIntegerScaleLimit);
    }

    static JsonNumber getJsonNumber(BigDecimal value, int bigIntegerScaleLimit) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        return new JsonBigDecimalNumber(value, bigIntegerScaleLimit);
    }

    static JsonNumber getJsonNumber(Number value, int bigIntegerScaleLimit) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        if (value instanceof Integer) {
            return JsonNumberImpl.getJsonNumber(value.intValue(), bigIntegerScaleLimit);
        }
        if (value instanceof Long) {
            return JsonNumberImpl.getJsonNumber(value.longValue(), bigIntegerScaleLimit);
        }
        if (value instanceof Double) {
            return JsonNumberImpl.getJsonNumber(value.doubleValue(), bigIntegerScaleLimit);
        }
        if (value instanceof BigInteger) {
            return JsonNumberImpl.getJsonNumber((BigInteger)value, bigIntegerScaleLimit);
        }
        if (value instanceof BigDecimal) {
            return JsonNumberImpl.getJsonNumber((BigDecimal)value, bigIntegerScaleLimit);
        }
        return new JsonNumberNumber(value, bigIntegerScaleLimit);
    }

    @Override
    public boolean isIntegral() {
        return this.bigDecimalValue().scale() == 0;
    }

    @Override
    public int intValue() {
        return this.bigDecimalValue().intValue();
    }

    @Override
    public int intValueExact() {
        return this.bigDecimalValue().intValueExact();
    }

    @Override
    public long longValue() {
        return this.bigDecimalValue().longValue();
    }

    @Override
    public long longValueExact() {
        return this.bigDecimalValue().longValueExact();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        BigDecimal bd = this.bigDecimalValue();
        if (bd.scale() <= this.bigIntegerScaleLimit) {
            return bd.toBigInteger();
        }
        throw new UnsupportedOperationException(String.format("Scale value %d of this BigInteger exceeded maximal allowed value of %d", bd.scale(), this.bigIntegerScaleLimit));
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        BigDecimal bd = this.bigDecimalValue();
        if (bd.scale() <= this.bigIntegerScaleLimit) {
            return bd.toBigIntegerExact();
        }
        throw new UnsupportedOperationException(String.format("Scale value %d of this BigInteger exceeded maximal allowed value of %d", bd.scale(), this.bigIntegerScaleLimit));
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.bigDecimalValue().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.bigDecimalValue().equals(other.bigDecimalValue());
    }

    @Override
    public String toString() {
        return this.bigDecimalValue().toString();
    }

    private static final class JsonBigDecimalNumber
    extends JsonNumberImpl {
        private final BigDecimal bigDecimal;

        JsonBigDecimalNumber(BigDecimal value, int bigIntegerScaleLimit) {
            super(bigIntegerScaleLimit);
            this.bigDecimal = value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return this.bigDecimal;
        }

        @Override
        public Number numberValue() {
            return this.bigDecimalValue();
        }
    }

    private static final class JsonLongNumber
    extends JsonNumberImpl {
        private final long num;
        private BigDecimal bigDecimal;

        JsonLongNumber(long num, int bigIntegerScaleLimit) {
            super(bigIntegerScaleLimit);
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return (int)this.num;
        }

        @Override
        public int intValueExact() {
            return Math.toIntExact(this.num);
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        @Override
        public Number numberValue() {
            return this.num;
        }

        @Override
        public String toString() {
            return Long.toString(this.num);
        }
    }

    private static final class JsonIntNumber
    extends JsonNumberImpl {
        private final int num;
        private BigDecimal bigDecimal;

        JsonIntNumber(int num, int bigIntegerScaleLimit) {
            super(bigIntegerScaleLimit);
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return this.num;
        }

        @Override
        public int intValueExact() {
            return this.num;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        @Override
        public Number numberValue() {
            return this.num;
        }

        @Override
        public String toString() {
            return Integer.toString(this.num);
        }
    }

    private static final class JsonNumberNumber
    extends JsonNumberImpl {
        private final Number num;
        private BigDecimal bigDecimal;

        JsonNumberNumber(Number num, int bigIntegerScaleLimit) {
            super(bigIntegerScaleLimit);
            this.num = num;
        }

        @Override
        public Number numberValue() {
            return this.num;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num.toString());
            }
            return bd;
        }
    }
}

