/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.rate.limit;

import io.smallrye.faulttolerance.core.rate.limit.FixedWindow;
import io.smallrye.faulttolerance.core.rate.limit.RingBufferRollingWindow;
import io.smallrye.faulttolerance.core.rate.limit.SmoothWindow;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;

public interface TimeWindow {
    public boolean record();

    public static TimeWindow createFixed(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        return new FixedWindow(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
    }

    public static TimeWindow createRolling(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        return new RingBufferRollingWindow(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
    }

    public static TimeWindow createSmooth(Stopwatch stopwatch, int maxInvocations, long timeWindowInMillis, long minSpacingInMillis) {
        return new SmoothWindow(stopwatch, maxInvocations, timeWindowInMillis, minSpacingInMillis);
    }
}

