/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.EeCapabilities;
import org.jboss.as.ee.subsystem.EeExtension;
import org.jboss.as.ee.subsystem.GlobalDirectoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;

public class GlobalDirectoryResourceDefinition
extends PersistentResourceDefinition {
    static SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"path", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).addArbitraryDescriptor("filesystem-path", new ModelNode(true))).setRestartAllServices()).build();
    static SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"relative-to", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{PATH, RELATIVE_TO};
    private static final AbstractAddStepHandler ADD = new GlobalDirectoryAddHandler();
    private static final AbstractRemoveStepHandler REMOVE = new ReloadRequiredRemoveStepHandler();

    GlobalDirectoryResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"global-directory"), EeExtension.getResourceDescriptionResolver("global-directory")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler((OperationStepHandler)REMOVE).setCapabilities(new RuntimeCapability[]{EeCapabilities.EE_GLOBAL_DIRECTORY_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])ATTRIBUTES);
        for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)handler);
        }
    }

    public static final class GlobalDirectory {
        private final Path resolvedPath;
        private final String name;

        public GlobalDirectory(Path resolvedPath, String name) {
            this.resolvedPath = resolvedPath;
            this.name = name;
        }

        public Path getResolvedPath() {
            return this.resolvedPath;
        }

        public String getName() {
            return this.name;
        }

        public String getModuleName() {
            return "global-directory." + this.name;
        }
    }

    private static class GlobalDirectoryAddHandler
    extends AbstractAddStepHandler {
        public GlobalDirectoryAddHandler() {
            super((AttributeDefinition[])ATTRIBUTES);
        }

        protected void populateModel(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext oc, ModelNode op) throws OperationFailedException {
                    String firstAdded;
                    Resource parentResource = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false);
                    Set globalDirectories = parentResource.getChildrenNames("global-directory");
                    String newName = context.getCurrentAddressValue();
                    String string = firstAdded = !globalDirectories.isEmpty() ? (String)globalDirectories.iterator().next() : null;
                    if (firstAdded != null && !firstAdded.equals(newName)) {
                        throw EeLogger.ROOT_LOGGER.oneGlobalDirectory(newName, firstAdded);
                    }
                }
            }, OperationContext.Stage.MODEL);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String path = PATH.resolveModelAttribute(context, model).asString();
            String relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(EeCapabilities.EE_GLOBAL_DIRECTORY_CAPABILITY);
            Consumer provides = serviceBuilder.provides(new RuntimeCapability[]{EeCapabilities.EE_GLOBAL_DIRECTORY_CAPABILITY});
            Supplier pathManagerSupplier = serviceBuilder.requiresCapability("org.wildfly.management.path-manager", PathManager.class, new String[0]);
            GlobalDirectoryService globalDirectoryService = new GlobalDirectoryService(pathManagerSupplier, provides, context.getCurrentAddressValue(), path, relativeTo);
            serviceBuilder.setInstance((Service)globalDirectoryService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

