/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.pattern.spi;

import java.util.Objects;
import java.util.Optional;

public abstract class SimpleGlobPattern {
    private static final char WILDCARD_MANY = '*';

    public static SimpleGlobPattern compile(String patternString) {
        SimpleGlobPattern pattern = EmptyGlobPattern.INSTANCE;
        int endIndexInclusive = patternString.length() - 1;
        while (endIndexInclusive >= 0) {
            int lastWildcardIndex = patternString.lastIndexOf(42, endIndexInclusive);
            if (lastWildcardIndex < endIndexInclusive) {
                pattern = pattern.prependLiteral(patternString.substring(lastWildcardIndex + 1, endIndexInclusive + 1));
            }
            if (0 <= lastWildcardIndex) {
                pattern = pattern.prependMany();
            }
            endIndexInclusive = lastWildcardIndex - 1;
        }
        return pattern;
    }

    private SimpleGlobPattern() {
    }

    public boolean matches(String candidate) {
        return this.matches(candidate, 0);
    }

    public SimpleGlobPattern prependLiteral(String literal) {
        if (literal.isEmpty()) {
            return this;
        }
        return new LiteralGlobPattern(literal, this);
    }

    public SimpleGlobPattern prependMany() {
        return new ManyGlobPattern(this);
    }

    public Optional<String> toLiteral() {
        return Optional.empty();
    }

    public abstract String toPatternString();

    protected abstract int minLength();

    protected abstract boolean matches(String var1, int var2);

    private static final class EmptyGlobPattern
    extends SimpleGlobPattern {
        static final EmptyGlobPattern INSTANCE = new EmptyGlobPattern();

        private EmptyGlobPattern() {
        }

        public String toString() {
            return "<EMPTY>";
        }

        @Override
        public String toPatternString() {
            return "";
        }

        @Override
        protected boolean matches(String candidate, int startIndex) {
            return startIndex == candidate.length();
        }

        @Override
        protected int minLength() {
            return 0;
        }
    }

    private static final class LiteralGlobPattern
    extends SimpleGlobPattern {
        private final String literal;
        private final SimpleGlobPattern next;

        private LiteralGlobPattern(String literal, SimpleGlobPattern next) {
            this.literal = literal;
            this.next = next;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LiteralGlobPattern other = (LiteralGlobPattern)obj;
            return this.literal.equals(other.literal) && this.next.equals(other.next);
        }

        public int hashCode() {
            return Objects.hash(this.literal, this.next);
        }

        public String toString() {
            if (this.next == EmptyGlobPattern.INSTANCE) {
                return this.literal;
            }
            return this.literal + this.next.toString();
        }

        @Override
        protected boolean matches(String candidate, int startIndex) {
            return this.literal.regionMatches(0, candidate, startIndex, this.literal.length()) && this.next.matches(candidate, startIndex + this.literal.length());
        }

        @Override
        public SimpleGlobPattern prependLiteral(String literal) {
            if (literal.isEmpty()) {
                return this;
            }
            return new LiteralGlobPattern(literal + this.literal, this.next);
        }

        @Override
        public Optional<String> toLiteral() {
            if (this.next != EmptyGlobPattern.INSTANCE) {
                return Optional.empty();
            }
            return Optional.of(this.literal);
        }

        @Override
        public String toPatternString() {
            return this.literal + this.next.toPatternString();
        }

        @Override
        protected int minLength() {
            return this.literal.length() + this.next.minLength();
        }
    }

    private static final class ManyGlobPattern
    extends SimpleGlobPattern {
        private final SimpleGlobPattern next;
        private final int minTailLength;

        private ManyGlobPattern(SimpleGlobPattern next) {
            this.next = next;
            this.minTailLength = next.minLength();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ManyGlobPattern other = (ManyGlobPattern)obj;
            return this.next.equals(other.next);
        }

        public int hashCode() {
            return Objects.hash(this.next);
        }

        public String toString() {
            if (this.next == EmptyGlobPattern.INSTANCE) {
                return "*";
            }
            return "*" + this.next.toString();
        }

        @Override
        protected boolean matches(String candidate, int startIndex) {
            int maxNextStartIndex;
            for (int i = maxNextStartIndex = candidate.length() - this.minTailLength; i >= startIndex; --i) {
                if (!this.next.matches(candidate, i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SimpleGlobPattern prependMany() {
            return this;
        }

        @Override
        public String toPatternString() {
            return '*' + this.next.toPatternString();
        }

        @Override
        protected int minLength() {
            return this.next.minLength();
        }
    }
}

