/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.util.TypeLiteral;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.weld.bean.builtin.AbstractFacade;
import org.jboss.weld.bean.builtin.DynamicLookupInjectionPoint;
import org.jboss.weld.bean.builtin.FacadeInjectionPoint;
import org.jboss.weld.bean.builtin.PriorityComparator;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.util.AnnotationApiAbstraction;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressFBWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR", "SE_BAD_FIELD"}, justification="Uses SerializationProxy")
public class InstanceImpl<T>
extends AbstractFacade<T, Instance<T>>
implements WeldInstance<T>,
Serializable {
    private static final long serialVersionUID = -376721889693284887L;
    private final transient Set<Bean<?>> allBeans;
    private final transient Bean<?> bean;
    private final transient CurrentInjectionPoint currentInjectionPoint;
    private final transient InjectionPoint ip;
    private final transient EjbSupport ejbSupport;

    public static <I> Instance<I> of(InjectionPoint injectionPoint, CreationalContext<I> creationalContext, BeanManagerImpl beanManager) {
        return new InstanceImpl<I>(injectionPoint, creationalContext, beanManager);
    }

    private InstanceImpl(InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        super(injectionPoint, creationalContext, beanManager);
        if (injectionPoint.getQualifiers().isEmpty() && Object.class.equals((Object)this.getType())) {
            this.allBeans = null;
            this.bean = null;
        } else {
            this.allBeans = this.resolveBeans();
            this.bean = this.allBeans.size() == 1 ? this.allBeans.iterator().next() : null;
        }
        this.currentInjectionPoint = (CurrentInjectionPoint)beanManager.getServices().getRequired(CurrentInjectionPoint.class);
        this.ip = new DynamicLookupInjectionPoint(this.getInjectionPoint(), this.getType(), this.getQualifiers());
        this.ejbSupport = (EjbSupport)beanManager.getServices().get(EjbSupport.class);
    }

    public T get() {
        this.checkBeanResolved();
        return this.getBeanInstance(this.bean);
    }

    public String toString() {
        return Formats.formatAnnotations(this.getQualifiers()) + " Instance<" + Formats.formatType(this.getType()) + ">";
    }

    public Iterator<T> iterator() {
        return new InstanceImplIterator(this.allBeans());
    }

    public boolean isAmbiguous() {
        return this.allBeans().size() > 1;
    }

    public boolean isUnsatisfied() {
        return this.allBeans().isEmpty();
    }

    public WeldInstance<T> select(Annotation ... qualifiers) {
        return this.selectInstance(this.getType(), qualifiers);
    }

    public <U extends T> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype, qualifiers);
    }

    public <U extends T> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.selectInstance(subtype.getType(), qualifiers);
    }

    public <X> WeldInstance<X> select(Type subtype, Annotation ... qualifiers) {
        if (!this.getType().equals(Object.class)) {
            throw BeanLogger.LOG.selectByTypeOnlyWorksOnObject();
        }
        return this.selectInstance(subtype, qualifiers);
    }

    private <U extends T> WeldInstance<U> selectInstance(Type subtype, Annotation[] newQualifiers) {
        FacadeInjectionPoint modifiedInjectionPoint = new FacadeInjectionPoint(this.getBeanManager(), this.getInjectionPoint(), (Type)((Object)Instance.class), subtype, this.getQualifiers(), newQualifiers);
        return new InstanceImpl(modifiedInjectionPoint, this.getCreationalContext(), this.getBeanManager());
    }

    public void destroy(T instance) {
        ProxyObject proxy;
        Preconditions.checkNotNull(instance);
        if (instance instanceof ProxyObject && (proxy = (ProxyObject)instance).weld_getHandler() instanceof ProxyMethodHandler) {
            ProxyMethodHandler handler = (ProxyMethodHandler)proxy.weld_getHandler();
            Bean<?> bean = handler.getBean();
            if (this.isSessionBeanProxy(instance) && Dependent.class.equals((Object)bean.getScope())) {
                this.destroyDependentInstance(instance);
                return;
            }
            Context context = this.getBeanManager().getContext(bean.getScope());
            if (context instanceof AlterableContext) {
                AlterableContext alterableContext = (AlterableContext)context;
                alterableContext.destroy(bean);
                return;
            }
            throw BeanLogger.LOG.destroyUnsupported(context);
        }
        this.destroyDependentInstance(instance);
    }

    public Instance.Handle<T> getHandle() {
        this.checkBeanResolved();
        return new HandlerImpl<Object>(() -> this.getBeanInstance(this.bean), this, this.bean);
    }

    public WeldInstance.Handler<T> getHandler() {
        return (WeldInstance.Handler)Reflections.cast(this.getHandle());
    }

    public boolean isResolvable() {
        return this.allBeans().size() == 1;
    }

    public Iterable<Instance.Handle<T>> handles() {
        return () -> new HandleIterator(this.allBeans());
    }

    public Iterable<WeldInstance.Handler<T>> handlers() {
        return (Iterable)Reflections.cast(this.handles());
    }

    public Comparator<WeldInstance.Handler<?>> getPriorityComparator() {
        return (Comparator)Reflections.cast(this.getHandlePriorityComparator());
    }

    public Comparator<Instance.Handle<?>> getHandlePriorityComparator() {
        return new PriorityComparator((AnnotationApiAbstraction)this.getBeanManager().getServices().get(AnnotationApiAbstraction.class));
    }

    private boolean isSessionBeanProxy(T instance) {
        return this.ejbSupport != null ? this.ejbSupport.isSessionBeanProxy(instance) : false;
    }

    private void destroyDependentInstance(T instance) {
        CreationalContext ctx = this.getCreationalContext();
        if (ctx instanceof WeldCreationalContext) {
            WeldCreationalContext weldCtx = (WeldCreationalContext)Reflections.cast(ctx);
            weldCtx.destroyDependentInstance(instance);
        }
    }

    private void checkBeanResolved() {
        if (this.bean != null) {
            return;
        }
        if (this.isUnsatisfied()) {
            throw BeanManagerLogger.LOG.injectionPointHasUnsatisfiedDependencies(Formats.formatAnnotations(this.ip.getQualifiers()), Formats.formatInjectionPointType(this.ip.getType()), InjectionPoints.getUnsatisfiedDependenciesAdditionalInfo(this.ip, this.getBeanManager()));
        }
        throw BeanManagerLogger.LOG.injectionPointHasAmbiguousDependencies(Formats.formatAnnotations(this.ip.getQualifiers()), Formats.formatInjectionPointType(this.ip.getType()), WeldCollections.toMultiRowString(this.allBeans()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getBeanInstance(Bean<?> bean) {
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.pushConditionally(this.ip, this.isRegisterableInjectionPoint());
        try {
            Object t = Reflections.cast(this.getBeanManager().getReference(bean, this.getType(), this.getCreationalContext(), false));
            return t;
        }
        finally {
            stack.pop();
        }
    }

    private boolean isRegisterableInjectionPoint() {
        return !this.getType().equals(InjectionPoint.class);
    }

    private Set<Bean<?>> allBeans() {
        return this.allBeans == null ? this.resolveBeans() : this.allBeans;
    }

    private Set<Bean<?>> resolveBeans() {
        Resolvable resolvable = new ResolvableBuilder(this.getType(), this.getBeanManager()).addQualifiers(this.getQualifiers()).setDeclaringBean(this.getInjectionPoint().getBean()).create();
        TypeSafeBeanResolver beanResolver = this.getBeanManager().getBeanResolver();
        return beanResolver.resolve((Set)beanResolver.resolve(resolvable, Reflections.isCacheable(this.getQualifiers())));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.serializationProxyRequired();
    }

    private static class HandlerImpl<T>
    implements WeldInstance.Handler<T> {
        private final LazyValueHolder<T> value;
        private final Bean<?> bean;
        private final WeakReference<WeldInstance<T>> instance;
        private final AtomicBoolean isDestroyed;

        HandlerImpl(Supplier<T> supplier, WeldInstance<T> instance, Bean<?> bean) {
            this.value = LazyValueHolder.forSupplier(supplier);
            this.bean = bean;
            this.instance = new WeakReference<WeldInstance<WeldInstance<T>>>(instance);
            this.isDestroyed = new AtomicBoolean(false);
        }

        public T get() {
            if (this.isDestroyed.get()) {
                throw BeanLogger.LOG.tryingToResolveContextualReferenceAfterDestroyWasInvoked(this);
            }
            if (!this.value.isAvailable() && this.instance.get() == null) {
                throw BeanLogger.LOG.cannotObtainHandlerContextualReference(this);
            }
            return this.value.get();
        }

        public Bean<T> getBean() {
            return this.bean;
        }

        public void destroy() {
            WeldInstance ref = (WeldInstance)this.instance.get();
            if (ref == null) {
                BeanLogger.LOG.cannotDestroyHandlerContextualReference(this);
            }
            if (this.value.isAvailable() && this.isDestroyed.compareAndSet(false, true)) {
                ref.destroy(this.value.get());
            }
        }

        public void close() {
            this.destroy();
        }

        public String toString() {
            return "HandlerImpl [bean=" + this.bean + "]";
        }
    }

    class HandleIterator
    extends BeanIterator<Instance.Handle<T>> {
        private HandleIterator(Set<Bean<?>> beans) {
            super(beans);
        }

        @Override
        public Instance.Handle<T> next() {
            Bean bean = (Bean)this.delegate.next();
            return new HandlerImpl<Object>(() -> InstanceImpl.this.getBeanInstance(bean), InstanceImpl.this, bean);
        }
    }

    class InstanceImplIterator
    extends BeanIterator<T> {
        private InstanceImplIterator(Set<Bean<?>> beans) {
            super(beans);
        }

        @Override
        public T next() {
            return InstanceImpl.this.getBeanInstance((Bean)this.delegate.next());
        }
    }

    abstract class BeanIterator<TYPE>
    implements Iterator<TYPE> {
        protected final Iterator<Bean<?>> delegate;

        private BeanIterator(Set<Bean<?>> beans) {
            this.delegate = beans.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public void remove() {
            throw BeanLogger.LOG.instanceIteratorRemoveUnsupported();
        }
    }

    private static class SerializationProxy<T>
    extends AbstractFacade.AbstractFacadeSerializationProxy<T, Instance<T>> {
        private static final long serialVersionUID = 9181171328831559650L;

        public SerializationProxy(InstanceImpl<T> instance) {
            super(instance);
        }

        private Object readResolve() throws ObjectStreamException {
            return InstanceImpl.of(this.getInjectionPoint(), this.getCreationalContext(), this.getBeanManager());
        }
    }
}

