/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.config.ConfigLogging;
import io.smallrye.jwt.config.ConfigMessages;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_SCHEME = "Bearer";
    private static final String NONE = "NONE";
    private static final String DEFAULT_GROUPS_SEPARATOR = " ";
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private String mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.algorithm")
    private Optional<SignatureAlgorithm> mpJwtPublicKeyAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private String mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.decrypt.key.location", defaultValue="NONE")
    private String mpJwtDecryptKeyLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.decrypt.key.algorithm", defaultValue="RSA_OAEP,RSA_OAEP_256")
    private Set<KeyEncryptionAlgorithm> mpJwtDecryptKeyAlgorithm = new HashSet<KeyEncryptionAlgorithm>(Arrays.asList(KeyEncryptionAlgorithm.RSA_OAEP, KeyEncryptionAlgorithm.RSA_OAEP_256));
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key")
    private Optional<String> jwtDecryptKey;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key.location", defaultValue="NONE")
    private String verifyKeyLocation;
    @Deprecated
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.key.location", defaultValue="NONE")
    private String decryptionKeyLocation;
    @Inject
    @ConfigProperty(name="smallrye.jwt.decrypt.algorithm")
    @Deprecated
    private Optional<KeyEncryptionAlgorithm> keyEncryptionAlgorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.token.header")
    private Optional<String> mpJwtTokenHeader;
    @Inject
    @ConfigProperty(name="mp.jwt.token.cookie")
    private Optional<String> mpJwtTokenCookie;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.audiences")
    Optional<Set<String>> mpJwtVerifyAudiences;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.clock.skew", defaultValue="60")
    private int mpJwtVerifyClockSkew;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.token.age")
    Optional<Long> mpJwtVerifyTokenAge;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header")
    @Deprecated
    private Optional<String> tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    @Deprecated
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.always-check-authorization", defaultValue="false")
    private boolean alwaysCheckAuthorization;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    private Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.decryption.kid")
    private Optional<String> tokenDecryptionKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.schemes", defaultValue="Bearer")
    private String tokenSchemes;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="true")
    private Optional<Boolean> requireNamedPrincipal = Optional.of(Boolean.TRUE);
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    private Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    private Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    private Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.groups-separator", defaultValue=" ")
    private String groupsSeparator;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="0")
    @Deprecated
    private int expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.time-to-live")
    Optional<Long> maxTimeToLiveSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    private int jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.forced-refresh-interval", defaultValue="30")
    private int forcedJwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.algorithm")
    private Optional<SignatureAlgorithm> signatureAlgorithm;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.certificateThumbprint", defaultValue="false")
    private boolean verifyCertificateThumbprint;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.key-format", defaultValue="ANY")
    private KeyFormat keyFormat;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.relax-key-validation", defaultValue="true")
    private boolean relaxVerificationKeyValidation = true;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.aud")
    @Deprecated
    Optional<Set<String>> expectedAudience;
    @Inject
    @ConfigProperty(name="smallrye.jwt.required.claims")
    Optional<Set<String>> requiredClaims;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.certificate")
    private Optional<String> tlsCertificate;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.certificate.path")
    private Optional<String> tlsCertificatePath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.trust-all", defaultValue="false")
    private boolean tlsTrustAll;
    @Inject
    @ConfigProperty(name="smallrye.jwt.client.tls.hosts")
    private Optional<Set<String>> tlsTrustedHosts;
    @Inject
    @ConfigProperty(name="smallrye.jwt.http.proxy.host")
    private Optional<String> httpProxyHost;
    @Inject
    @ConfigProperty(name="smallrye.jwt.http.proxy.port", defaultValue="80")
    private int httpProxyPort = 80;
    @ConfigProperty(name="smallrye.jwt.keystore.type")
    private Optional<String> keyStoreType = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.provider")
    private Optional<String> keyStoreProvider = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.password")
    private Optional<String> keyStorePassword = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.verify.key.alias")
    private Optional<String> keyStoreVerifyKeyAlias = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.decrypt.key.alias")
    private Optional<String> keyStoreDecryptKeyAlias = Optional.empty();
    @ConfigProperty(name="smallrye.jwt.keystore.decrypt.key.password")
    private Optional<String> keyStoreDecryptKeyPassword = Optional.empty();

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithDecryptionKey(String decryptionKey, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, NONE, false, false, issuer, Optional.of(decryptionKey));
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithCertificate(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, false, true, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithSecretKeyLocation(String keyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, true, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithVerifyKeyStoreLocation(String keyLocation, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, Optional.empty(), Optional.empty(), theKeyStorePassword, theKeyStoreVerifyKeyAlias, theKeyStoreDecryptKeyAlias, false, false, issuer, Optional.empty());
    }

    public static JWTAuthContextInfoProvider createWithKeyStoreLocation(String keyLocation, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, keyLocation, Optional.empty(), Optional.empty(), theKeyStorePassword, theKeyStoreVerifyKeyAlias, theKeyStoreDecryptKeyAlias, false, false, issuer, Optional.empty());
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String keyLocation, boolean secretKey, boolean verifyCertificateThumbprint, String issuer, Optional<String> decryptionKey) {
        return JWTAuthContextInfoProvider.create(publicKey, keyLocation, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), secretKey, verifyCertificateThumbprint, issuer, decryptionKey);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String keyLocation, Optional<String> theKeyStoreType, Optional<String> theKeyStoreProvider, Optional<String> theKeyStorePassword, Optional<String> theKeyStoreVerifyKeyAlias, Optional<String> theKeyStoreDecryptKeyAlias, boolean secretKey, boolean verifyCertificateThumbprint, String issuer, Optional<String> decryptionKey) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = publicKey;
        provider.mpJwtPublicKeyAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.mpJwtLocation = !secretKey && !theKeyStoreDecryptKeyAlias.isPresent() ? keyLocation : NONE;
        provider.verifyKeyLocation = secretKey ? keyLocation : NONE;
        provider.verifyCertificateThumbprint = verifyCertificateThumbprint;
        provider.mpJwtIssuer = issuer;
        provider.mpJwtDecryptKeyLocation = theKeyStoreDecryptKeyAlias.isPresent() ? keyLocation : NONE;
        provider.jwtDecryptKey = decryptionKey;
        provider.decryptionKeyLocation = NONE;
        provider.mpJwtTokenHeader = Optional.of(AUTHORIZATION_HEADER);
        provider.mpJwtTokenCookie = Optional.of(BEARER_SCHEME);
        provider.tokenHeader = provider.mpJwtTokenHeader;
        provider.tokenCookie = provider.mpJwtTokenCookie;
        provider.tokenKeyId = Optional.empty();
        provider.tokenDecryptionKeyId = Optional.empty();
        provider.tokenSchemes = BEARER_SCHEME;
        provider.requireNamedPrincipal = Optional.of(Boolean.TRUE);
        provider.defaultSubClaim = Optional.empty();
        provider.subPath = Optional.empty();
        provider.defaultGroupsClaim = Optional.empty();
        provider.groupsPath = Optional.empty();
        provider.expGracePeriodSecs = 0;
        provider.maxTimeToLiveSecs = Optional.empty();
        provider.mpJwtVerifyClockSkew = 60;
        provider.mpJwtVerifyTokenAge = Optional.empty();
        provider.jwksRefreshInterval = 60;
        provider.forcedJwksRefreshInterval = 30;
        provider.signatureAlgorithm = Optional.of(SignatureAlgorithm.RS256);
        provider.keyEncryptionAlgorithm = Optional.empty();
        provider.mpJwtDecryptKeyAlgorithm = new HashSet<KeyEncryptionAlgorithm>(Arrays.asList(KeyEncryptionAlgorithm.RSA_OAEP, KeyEncryptionAlgorithm.RSA_OAEP_256));
        provider.keyFormat = KeyFormat.ANY;
        provider.mpJwtVerifyAudiences = Optional.empty();
        provider.expectedAudience = Optional.empty();
        provider.groupsSeparator = DEFAULT_GROUPS_SEPARATOR;
        provider.requiredClaims = Optional.empty();
        provider.tlsCertificate = Optional.empty();
        provider.tlsCertificatePath = Optional.empty();
        provider.tlsTrustedHosts = Optional.empty();
        provider.httpProxyHost = Optional.empty();
        provider.httpProxyPort = 80;
        provider.keyStoreType = theKeyStoreType;
        provider.keyStoreProvider = theKeyStoreProvider;
        provider.keyStorePassword = theKeyStorePassword;
        provider.keyStoreVerifyKeyAlias = theKeyStoreVerifyKeyAlias;
        provider.keyStoreDecryptKeyAlias = theKeyStoreDecryptKeyAlias;
        provider.keyStoreDecryptKeyPassword = Optional.empty();
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        Set<KeyEncryptionAlgorithm> theDecryptionKeyAlgorithm;
        Optional<Object> resolvedAlgorithm;
        JWTAuthContextInfo contextInfo;
        String resolvedVerifyKeyLocation;
        block54: {
            block58: {
                String theDecryptionKeyLocation;
                block57: {
                    block53: {
                        block56: {
                            block55: {
                                resolvedVerifyKeyLocation = !NONE.equals(this.verifyKeyLocation) ? this.verifyKeyLocation : this.mpJwtLocation;
                                contextInfo = new JWTAuthContextInfo();
                                if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
                                    contextInfo.setIssuedBy(this.mpJwtIssuer.trim());
                                }
                                if (NONE.equals(this.mpJwtPublicKey)) break block55;
                                contextInfo.setPublicKeyContent(this.mpJwtPublicKey);
                                break block53;
                            }
                            if (NONE.equals(resolvedVerifyKeyLocation)) break block56;
                            String resolvedVerifyKeyLocationTrimmed = resolvedVerifyKeyLocation.trim();
                            if (resolvedVerifyKeyLocationTrimmed.startsWith("http")) {
                                contextInfo.setPublicKeyLocation(resolvedVerifyKeyLocationTrimmed);
                                break block53;
                            } else {
                                if (this.isPublicKeyInKeystore()) {
                                    try {
                                        contextInfo.setPublicVerificationKey(this.getVerificationKeyFromKeystore(resolvedVerifyKeyLocationTrimmed));
                                    }
                                    catch (Exception ex) {
                                        throw ConfigMessages.msg.readingPublicKeyLocationFailed(ex);
                                    }
                                }
                                try {
                                    contextInfo.setPublicKeyContent(ResourceUtils.readResource((String)resolvedVerifyKeyLocationTrimmed));
                                    if (contextInfo.getPublicKeyContent() == null) {
                                        throw ConfigMessages.msg.invalidPublicKeyLocation();
                                    }
                                    break block53;
                                }
                                catch (IOException ex) {
                                    throw ConfigMessages.msg.readingPublicKeyLocationFailed(ex);
                                }
                            }
                        }
                        if (this.isPublicKeyInKeystore()) {
                            try {
                                contextInfo.setPublicVerificationKey(this.getVerificationKeyFromKeystore(null));
                            }
                            catch (Exception ex) {
                                throw ConfigMessages.msg.readingPublicKeyLocationFailed(ex);
                            }
                        }
                    }
                    if (!NONE.equals(this.mpJwtDecryptKeyLocation)) {
                        theDecryptionKeyLocation = this.mpJwtDecryptKeyLocation;
                    } else if (!NONE.equals(this.decryptionKeyLocation)) {
                        ConfigLogging.log.replacedConfig("smallrye.jwt.decrypt.key.location", "mp.jwt.decrypt.key.location");
                        theDecryptionKeyLocation = this.decryptionKeyLocation;
                    } else {
                        theDecryptionKeyLocation = NONE;
                    }
                    if (!this.jwtDecryptKey.isPresent()) break block57;
                    contextInfo.setDecryptionKeyContent(this.jwtDecryptKey.get());
                    break block54;
                }
                if (NONE.equals(theDecryptionKeyLocation)) break block58;
                String decryptionKeyLocationTrimmed = theDecryptionKeyLocation.trim();
                if (decryptionKeyLocationTrimmed.startsWith("http")) {
                    contextInfo.setDecryptionKeyLocation(decryptionKeyLocationTrimmed);
                    break block54;
                } else {
                    if (this.isPrivateKeyInKeystore()) {
                        try {
                            contextInfo.setPrivateDecryptionKey(this.getDecryptionKeyFromKeystore(decryptionKeyLocationTrimmed));
                        }
                        catch (Exception ex) {
                            throw ConfigMessages.msg.readingDecryptKeyLocationFailed(ex);
                        }
                    }
                    try {
                        contextInfo.setDecryptionKeyContent(ResourceUtils.readResource((String)decryptionKeyLocationTrimmed));
                        if (contextInfo.getDecryptionKeyContent() == null) {
                            throw ConfigMessages.msg.invalidDecryptKeyLocation();
                        }
                        break block54;
                    }
                    catch (IOException ex) {
                        throw ConfigMessages.msg.readingDecryptKeyLocationFailed(ex);
                    }
                }
            }
            if (this.isPrivateKeyInKeystore()) {
                try {
                    contextInfo.setPrivateDecryptionKey(this.getDecryptionKeyFromKeystore(null));
                }
                catch (Exception ex) {
                    throw ConfigMessages.msg.readingDecryptKeyLocationFailed(ex);
                }
            }
        }
        if (this.mpJwtTokenHeader.isPresent()) {
            contextInfo.setTokenHeader(this.mpJwtTokenHeader.get());
        } else if (this.tokenHeader.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.header", "mp.jwt.token.header");
            contextInfo.setTokenHeader(this.tokenHeader.get());
        } else {
            contextInfo.setTokenHeader(AUTHORIZATION_HEADER);
        }
        if (this.mpJwtTokenCookie.isPresent()) {
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.mpJwtTokenCookie);
        } else if (this.tokenCookie.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.token.cookie", "mp.jwt.token.cookie");
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.tokenCookie);
        } else {
            SmallryeJwtUtils.setContextTokenCookie(contextInfo, Optional.of(BEARER_SCHEME));
        }
        if (this.expGracePeriodSecs > 0) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.expiration.grace", "mp.jwt.verify.clock.skew");
            contextInfo.setClockSkew(this.expGracePeriodSecs);
        } else if (this.mpJwtVerifyClockSkew > 0) {
            contextInfo.setClockSkew(this.mpJwtVerifyClockSkew);
        }
        contextInfo.setAlwaysCheckAuthorization(this.alwaysCheckAuthorization);
        contextInfo.setTokenKeyId(this.tokenKeyId.orElse(null));
        contextInfo.setTokenDecryptionKeyId(this.tokenDecryptionKeyId.orElse(null));
        contextInfo.setRequireNamedPrincipal((Boolean)this.requireNamedPrincipal.orElse(null));
        SmallryeJwtUtils.setTokenSchemes(contextInfo, this.tokenSchemes);
        contextInfo.setDefaultSubjectClaim(this.defaultSubClaim.orElse(null));
        SmallryeJwtUtils.setContextSubPath(contextInfo, this.subPath);
        contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.orElse(null));
        contextInfo.setTlsCertificate(this.tlsCertificate.orElse(null));
        contextInfo.setTlsCertificatePath(this.tlsCertificatePath.orElse(null));
        contextInfo.setTlsTrustedHosts(this.tlsTrustedHosts.orElse(null));
        contextInfo.setTlsTrustAll(this.tlsTrustAll);
        contextInfo.setHttpProxyHost(this.httpProxyHost.orElse(null));
        contextInfo.setHttpProxyPort(this.httpProxyPort);
        SmallryeJwtUtils.setContextGroupsPath(contextInfo, this.groupsPath);
        contextInfo.setMaxTimeToLiveSecs(this.maxTimeToLiveSecs.orElse(null));
        contextInfo.setTokenAge(this.mpJwtVerifyTokenAge.orElse(null));
        contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval);
        contextInfo.setForcedJwksRefreshInterval(this.forcedJwksRefreshInterval);
        if (this.mpJwtPublicKeyAlgorithm.isPresent()) {
            resolvedAlgorithm = this.mpJwtPublicKeyAlgorithm;
        } else if (this.signatureAlgorithm.isPresent()) {
            if (this.signatureAlgorithm.get().getAlgorithm().startsWith("HS")) {
                if (resolvedVerifyKeyLocation == this.mpJwtLocation) {
                    throw ConfigMessages.msg.hmacNotSupported();
                }
            } else {
                ConfigLogging.log.replacedConfig("smallrye.jwt.verify.algorithm", "mp.jwt.verify.publickey.algorithm");
            }
            resolvedAlgorithm = this.signatureAlgorithm;
        } else {
            resolvedAlgorithm = Optional.empty();
        }
        if (resolvedAlgorithm.isPresent()) {
            contextInfo.setSignatureAlgorithm((SignatureAlgorithm)resolvedAlgorithm.get());
        } else {
            contextInfo.setSignatureAlgorithm(SignatureAlgorithm.RS256);
        }
        if (!this.keyEncryptionAlgorithm.isEmpty()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.decrypt.algorithm", "mp.jwt.decrypt.key.algorithm");
            theDecryptionKeyAlgorithm = Collections.singleton(this.keyEncryptionAlgorithm.get());
        } else {
            theDecryptionKeyAlgorithm = this.mpJwtDecryptKeyAlgorithm;
        }
        contextInfo.setKeyEncryptionAlgorithm(theDecryptionKeyAlgorithm);
        contextInfo.setKeyFormat(this.keyFormat);
        if (this.mpJwtVerifyAudiences.isPresent()) {
            contextInfo.setExpectedAudience(this.mpJwtVerifyAudiences.get());
        } else if (this.expectedAudience.isPresent()) {
            ConfigLogging.log.replacedConfig("smallrye.jwt.verify.aud", "mp.jwt.verify.audiences");
            contextInfo.setExpectedAudience(this.expectedAudience.get());
        } else {
            contextInfo.setExpectedAudience(null);
        }
        contextInfo.setGroupsSeparator(this.groupsSeparator);
        contextInfo.setRequiredClaims(this.requiredClaims.orElse(null));
        contextInfo.setRelaxVerificationKeyValidation(this.relaxVerificationKeyValidation);
        contextInfo.setVerifyCertificateThumbprint(this.verifyCertificateThumbprint);
        return Optional.of(contextInfo);
    }

    private PublicKey getVerificationKeyFromKeystore(String keyStorePath) throws Exception {
        KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)this.keyStorePassword.get(), this.keyStoreType, this.keyStoreProvider);
        return keyStore.getCertificate(this.keyStoreVerifyKeyAlias.get()).getPublicKey();
    }

    private PrivateKey getDecryptionKeyFromKeystore(String keyStorePath) throws Exception {
        KeyStore keyStore = KeyUtils.loadKeyStore((String)keyStorePath, (String)this.keyStorePassword.get(), this.keyStoreType, this.keyStoreProvider);
        return (PrivateKey)keyStore.getKey(this.keyStoreDecryptKeyAlias.get(), this.keyStoreDecryptKeyPassword.orElse(this.keyStorePassword.get()).toCharArray());
    }

    private boolean isPublicKeyInKeystore() {
        return this.keyStorePassword.isPresent() && this.keyStoreVerifyKeyAlias.isPresent();
    }

    private boolean isPrivateKeyInKeystore() {
        return this.keyStorePassword.isPresent() && this.keyStoreDecryptKeyAlias.isPresent();
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

