/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.impl.OutboxPollingCoordinationStrategy;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.mapping.OutboxPollingSearchMapping;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.SearchMappingExtension;
import org.hibernate.search.mapper.orm.mapping.spi.CoordinationStrategyContext;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@Incubating
public class OutboxPollingExtension
implements SearchMappingExtension<OutboxPollingSearchMapping> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OutboxPollingExtension instance = new OutboxPollingExtension();

    public OutboxPollingSearchMapping extendOrFail(SearchMapping original) {
        if (!(original instanceof CoordinationStrategyContext)) {
            throw log.outboxPollingExtensionOnUnknownType(original);
        }
        CoordinationStrategy coordinationStrategy = ((CoordinationStrategyContext)original).coordinationStrategy();
        if (coordinationStrategy instanceof OutboxPollingCoordinationStrategy) {
            return ((OutboxPollingCoordinationStrategy)coordinationStrategy).outboxPollingSearchMapping();
        }
        throw log.outboxPollingExtensionOnUnknownType(original);
    }

    public static OutboxPollingExtension get() {
        return instance;
    }
}

