/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.avro.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.avro.generated.impl.PojoIndexingQueueEventPayloadDto;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.avro.impl.EventPayloadFromDtoConverterUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.avro.impl.EventPayloadToDtoConverterUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class EventPayloadSerializationUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private EventPayloadSerializationUtils() {
    }

    public static byte[] serialize(PojoIndexingQueueEventPayload payload) {
        SpecificDatumWriter writer = new SpecificDatumWriter(PojoIndexingQueueEventPayloadDto.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        try {
            writer.write((Object)EventPayloadToDtoConverterUtils.convert(payload), (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToSerializeOutboxEventPayloadWithAvro(e.getMessage(), e);
        }
        return out.toByteArray();
    }

    public static PojoIndexingQueueEventPayload deserialize(byte[] payloadData) {
        SpecificDatumReader reader = new SpecificDatumReader(PojoIndexingQueueEventPayloadDto.class);
        ByteArrayInputStream in = new ByteArrayInputStream(payloadData);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
        try {
            return EventPayloadFromDtoConverterUtils.convert((PojoIndexingQueueEventPayloadDto)((Object)reader.read(null, (Decoder)decoder)));
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToDeserializeOutboxEventPayloadWithAvro(e.getMessage(), e);
        }
    }
}

