/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class ShardAssignmentDescriptor {
    public final int totalShardCount;
    public final int assignedShardIndex;

    public static Optional<ShardAssignmentDescriptor> fromClusterMemberList(List<UUID> clusterMembersInShardOrder, UUID selfId) {
        int totalShardCount = clusterMembersInShardOrder.size();
        int assignedShard = clusterMembersInShardOrder.indexOf(selfId);
        if (assignedShard < 0) {
            return Optional.empty();
        }
        return Optional.of(new ShardAssignmentDescriptor(totalShardCount, assignedShard));
    }

    public ShardAssignmentDescriptor(int totalShardCount, int assignedShardIndex) {
        this.totalShardCount = totalShardCount;
        this.assignedShardIndex = assignedShardIndex;
    }

    public String toString() {
        return "shard " + this.assignedShardIndex + " (total " + this.totalShardCount + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardAssignmentDescriptor that = (ShardAssignmentDescriptor)o;
        return this.totalShardCount == that.totalShardCount && this.assignedShardIndex == that.assignedShardIndex;
    }

    public int hashCode() {
        return Objects.hash(this.totalShardCount, this.assignedShardIndex);
    }
}

