/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventFinder;

final class OutboxPollingEventProcessingInstructions {
    private final Clock clock;
    final Instant expiration;
    final Optional<OutboxEventFinder> eventFinder;

    public OutboxPollingEventProcessingInstructions(Clock clock, Instant expiration, Optional<OutboxEventFinder> eventFinder) {
        this.clock = clock;
        this.expiration = expiration;
        this.eventFinder = eventFinder;
    }

    boolean isStillValid() {
        return this.timeInMillisecondsToExpiration() > 0L;
    }

    long timeInMillisecondsToExpiration() {
        return Math.max(0L, this.expiration.toEpochMilli() - this.clock.millis());
    }
}

