/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl;

import jakarta.persistence.OptimisticLockException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void outboxEventGeneratedEntityMapping(String xmlMappingDefinition) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.outboxEventGeneratedEntityMapping$str(), (Object)xmlMappingDefinition);
    }

    protected String outboxEventGeneratedEntityMapping$str() {
        return "HSEARCH850001: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }

    protected String maxRetryExhausted$str() {
        return "HSEARCH850003: Max '%1$s' retries exhausted to process the event. Event will be aborted.";
    }

    @Override
    public final SearchException maxRetryExhausted(int retries) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.maxRetryExhausted$str(), retries));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void backgroundIndexingRetry(UUID eventId, String entityName, String entityId, int attempts, Instant processAfter) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.backgroundIndexingRetry$str(), new Object[]{eventId, entityName, entityId, attempts, processAfter});
    }

    protected String backgroundIndexingRetry$str() {
        return "HSEARCH850004: Background indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Attempts so far: %4$d. The event will be reprocessed after the moment: %5$s.";
    }

    @Override
    public final void startingOutboxEventProcessor(String name, ToStringTreeAppendable processor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingOutboxEventProcessor$str(), (Object)name, (Object)new ToStringTreeMultilineFormatter((Object)processor));
    }

    protected String startingOutboxEventProcessor$str() {
        return "HSEARCH850005: Starting outbox event processor '%1$s': %2$s";
    }

    @Override
    public final void stoppingOutboxEventProcessor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingOutboxEventProcessor$str(), (Object)name);
    }

    protected String stoppingOutboxEventProcessor$str() {
        return "HSEARCH850006: Stopping outbox event processor '%1$s'";
    }

    protected String invalidTotalShardCount$str() {
        return "HSEARCH850007: The total shard count must be strictly positive.";
    }

    @Override
    public final SearchException invalidTotalShardCount() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTotalShardCount$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidShardIndex$str() {
        return "HSEARCH850008: Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').";
    }

    @Override
    public final SearchException invalidShardIndex(int totalShardCount, String totalShardCountPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidShardIndex$str(), totalShardCount, totalShardCountPropertyKey));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingPropertyForStaticSharding$str() {
        return "HSEARCH850009: This property must be set when '%s' is set.";
    }

    @Override
    public final SearchException missingPropertyForStaticSharding(String otherPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyForStaticSharding$str(), otherPropertyKey));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void eventProcessorDisabled(String tenantId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.eventProcessorDisabled$str(), (Object)tenantId);
    }

    protected String eventProcessorDisabled$str() {
        return "HSEARCH850010: The outbox event processor is disabled for tenant '%s'.  Events will accumulate in the outbox table and indexes will not be updated, unless another application node connects to the same database with their event processor enabled.";
    }

    @Override
    public final void outboxEventProcessorUnableToLock(String name, OptimisticLockException lockException) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)lockException, this.outboxEventProcessorUnableToLock$str(), (Object)name);
    }

    protected String outboxEventProcessorUnableToLock$str() {
        return "HSEARCH850011: '%1$s' failed to obtain a lock on events to process; will try again later.";
    }

    protected String unableToSerializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850012: Unable to serialize OutboxEvent payload with Avro: %1$s";
    }

    @Override
    public final SearchException unableToSerializeOutboxEventPayloadWithAvro(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSerializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToDeserializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850013: Unable to deserialize OutboxEvent payload with Avro: %1$s";
    }

    @Override
    public final SearchException unableToDeserializeOutboxEventPayloadWithAvro(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeserializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void agentGeneratedEntityMapping(String xmlMappingDefinition) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.agentGeneratedEntityMapping$str(), (Object)xmlMappingDefinition);
    }

    protected String agentGeneratedEntityMapping$str() {
        return "HSEARCH850014: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }

    protected String invalidPollingIntervalAndPulseInterval$str() {
        return "HSEARCH850015: The pulse interval must be greater than or equal to the polling interval i.e. in this case at least %s";
    }

    @Override
    public final SearchException invalidPollingIntervalAndPulseInterval(long pollingInterval) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPollingIntervalAndPulseInterval$str(), pollingInterval));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPulseIntervalAndPulseExpiration$str() {
        return "HSEARCH850016: The pulse expiration must be greater than or equal to 3 times the pulse interval i.e. in this case at least %s";
    }

    @Override
    public final SearchException invalidPulseIntervalAndPulseExpiration(long pulseInterfaceTimes3) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPulseIntervalAndPulseExpiration$str(), pulseInterfaceTimes3));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String outboxEventProcessorPulse$str() {
        return "Pulse operation for agent '%1$s'";
    }

    @Override
    public final String outboxEventProcessorPulse(AgentReference agentReference) {
        return String.format(this.getLoggingLocale(), this.outboxEventProcessorPulse$str(), agentReference);
    }

    protected String outboxEventProcessorPulseFailed$str() {
        return "HSEARCH850017: Agent '%1$s': failed to infer a target cluster from the list of registered agents. The agent will try again in the next pulse. Cause: %2$s Registered agents: %3$s.";
    }

    @Override
    public final SearchException outboxEventProcessorPulseFailed(AgentReference agentReference, String causeMessage, List<Agent> allAgentsInIdOrder, RuntimeException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxEventProcessorPulseFailed$str(), agentReference, causeMessage, allAgentsInIdOrder), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void removingTimedOutAgents(AgentReference agentReference, List<Agent> timedOutAgents) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.removingTimedOutAgents$str(), (Object)agentReference, timedOutAgents);
    }

    protected String removingTimedOutAgents$str() {
        return "HSEARCH850018: Agent '%1$s': the registration of some agents in the outbox-polling strategy are considered expired and will be forcibly removed: %2$s. These agents did not update their registration in the database in time. This can be caused by invalid configuration (expiration lower than how long it takes to process a batch of events) or by an application node being forcibly stopped (disconnection from the network, application crash).";
    }

    protected String conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str() {
        return "HSEARCH850019: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which expects %4$s shards. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and expecting a different amount of shards; consider adjusting the configuration or switching to dynamic sharding.";
    }

    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(AgentReference reference, ShardAssignmentDescriptor staticShardAssignment, AgentReference conflictingAgentReference, int conflictingAgentTotalShardCount) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference, conflictingAgentTotalShardCount));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str() {
        return "HSEARCH850020: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which is also assigned to that shard. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and being assigned to the same shard; consider adjusting the configuration or switching to dynamic sharding.";
    }

    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(AgentReference reference, ShardAssignmentDescriptor staticShardAssignment, AgentReference conflictingAgentReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void startingOutboxMassIndexerAgent(String name, ToStringTreeAppendable processor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingOutboxMassIndexerAgent$str(), (Object)name, (Object)new ToStringTreeMultilineFormatter((Object)processor));
    }

    protected String startingOutboxMassIndexerAgent$str() {
        return "HSEARCH850021: Starting outbox mass indexer agent '%1$s': %2$s";
    }

    @Override
    public final void stoppingOutboxMassIndexerAgent(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingOutboxMassIndexerAgent$str(), (Object)name);
    }

    protected String stoppingOutboxMassIndexerAgent$str() {
        return "HSEARCH850022: Stopping outbox mass indexer agent '%1$s'";
    }

    protected String outboxPollingExtensionOnUnknownType$str() {
        return "HSEARCH850023: Invalid target for Outbox Polling extension: '%1$s'. This extension can only be applied when Hibernate Search is configured to use the 'outbox-polling' coordination strategy.";
    }

    @Override
    public final SearchException outboxPollingExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxPollingExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noTenantIdSpecified$str() {
        return "HSEARCH850024: Multi-tenancy is enabled but no tenant id is specified. Available tenants are: '%1$s'.";
    }

    @Override
    public final SearchException noTenantIdSpecified(Set<String> tenantIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noTenantIdSpecified$str(), tenantIds));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyNotEnabled$str() {
        return "HSEARCH850025: Multi-tenancy is not enabled but a tenant id is specified. Trying to use the tenant id: '%1$s'.";
    }

    @Override
    public final SearchException multiTenancyNotEnabled(String tenantId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotEnabled$str(), tenantId));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String agentConfigurationPropertyConflict$str() {
        return "HSEARCH850026: Outbox polling agent configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }

    @Override
    public final SearchException agentConfigurationPropertyConflict(String mappingPropertyName, String[] nameAdjustmentProperties) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.agentConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String outboxEventConfigurationPropertyConflict$str() {
        return "HSEARCH850027: Outbox event configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }

    @Override
    public final SearchException outboxEventConfigurationPropertyConflict(String mappingPropertyName, String[] nameAdjustmentProperties) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxEventConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String agentRegistrationIneffective$str() {
        return "HSEARCH850028: Agent '%1$s': could not find the agent after starting a new transaction. The agent was present just a moment ago. Either this problem is a rare occurrence, or the pulse expiration delay is too short.";
    }

    @Override
    public final SearchException agentRegistrationIneffective(AgentReference agentReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.agentRegistrationIneffective$str(), agentReference));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH850029: Nonblocking operation submitter is not supported.";
    }

    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonblockingOperationSubmitterNotSupported$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidUuidGenerationStrategyName$str() {
        return "HSEARCH850030: Invalid name for the UUID generation strategy: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidUuidGenerationStrategyName(String name, List<String> values) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidUuidGenerationStrategyName$str(), name, values));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidOutboxEventProcessingOrderName$str() {
        return "HSEARCH850031: Invalid name for the outbox event processing order: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidOutboxEventProcessingOrderName(String name, List<String> values) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidOutboxEventProcessingOrderName$str(), name, values));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

