/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.impl.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.lock.impl.externalizers.ExternalizerIds;
import org.infinispan.util.ByteString;

public class ClusteredLockKey {
    public static final AdvancedExternalizer<ClusteredLockKey> EXTERNALIZER = new Externalizer();
    private final ByteString name;

    public ClusteredLockKey(ByteString name) {
        this.name = Objects.requireNonNull(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredLockKey that = (ClusteredLockKey)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "ClusteredLockKey{name=" + this.name + "}";
    }

    public ByteString getName() {
        return this.name;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ClusteredLockKey> {
        private Externalizer() {
        }

        public Set<Class<? extends ClusteredLockKey>> getTypeClasses() {
            return Collections.singleton(ClusteredLockKey.class);
        }

        public Integer getId() {
            return ExternalizerIds.CLUSTERED_LOCK_KEY;
        }

        public void writeObject(ObjectOutput output, ClusteredLockKey object) throws IOException {
            ByteString.writeObject((ObjectOutput)output, (ByteString)object.name);
        }

        public ClusteredLockKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ClusteredLockKey(ByteString.readObject((ObjectInput)input));
        }
    }
}

