/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class JaxbMappingHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private JaxbMappingHelper() {
    }

    public static String marshall(JaxbEntityMappings mappings) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappings.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)mappings, (OutputStream)out);
            string = out.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | IOException e) {
                throw log.unableToProcessEntityMappings(e.getMessage(), (Exception)e);
            }
        }
        out.close();
        return string;
    }

    public static JaxbEntityMappings unmarshall(String mappings) {
        JaxbEntityMappings jaxbEntityMappings;
        ByteArrayInputStream in = new ByteArrayInputStream(mappings.getBytes(StandardCharsets.UTF_8));
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappings.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            jaxbEntityMappings = (JaxbEntityMappings)unmarshaller.unmarshal((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException | IOException e) {
                throw log.unableToProcessEntityMappings(e.getMessage(), (Exception)e);
            }
        }
        in.close();
        return jaxbEntityMappings;
    }
}

