/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RequestLimitingHandler;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.filters.PredicateHandlerWrapper;
import org.wildfly.extension.undertow.filters.SimpleFilterDefinition;

public class RequestLimitHandlerDefinition
extends SimpleFilterDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"request-limit");
    public static final AttributeDefinition MAX_CONCURRENT_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-concurrent-requests", ModelType.INT).setValidator((ParameterValidator)new IntRangeValidator(1, false, true))).setAllowExpression(true)).setRequired(true)).setRestartAllServices()).build();
    public static final AttributeDefinition QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("queue-size", ModelType.INT).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setAllowExpression(true)).setRequired(false)).setDefaultValue(ModelNode.ZERO)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(MAX_CONCURRENT_REQUESTS, QUEUE_SIZE);

    RequestLimitHandlerDefinition() {
        super(PATH_ELEMENT, RequestLimitHandlerDefinition::createHandlerWrapper);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static PredicateHandlerWrapper createHandlerWrapper(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxConcurrentRequests = MAX_CONCURRENT_REQUESTS.resolveModelAttribute(context, model).asInt();
        final int queueSize = QUEUE_SIZE.resolveModelAttribute(context, model).asInt();
        return PredicateHandlerWrapper.filter(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler next) {
                return new RequestLimitingHandler(maxConcurrentRequests, queueSize, next);
            }
        });
    }
}

