/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.pool;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class StrictMaxPoolConfigService
implements Service<StrictMaxPoolConfig> {
    private final Consumer<StrictMaxPoolConfig> configConsumer;
    private final Supplier<Integer> maxThreadsSupplier;
    private final StrictMaxPoolConfig poolConfig;
    private volatile int declaredMaxSize;
    private volatile Derive derive;

    public StrictMaxPoolConfigService(Consumer<StrictMaxPoolConfig> configConsumer, Supplier<Integer> maxThreadsSupplier, String poolName, int declaredMaxSize, Derive derive, long timeout, TimeUnit timeUnit) {
        this.configConsumer = configConsumer;
        this.maxThreadsSupplier = maxThreadsSupplier;
        this.declaredMaxSize = declaredMaxSize;
        this.derive = derive;
        this.poolConfig = new StrictMaxPoolConfig(poolName, declaredMaxSize, timeout, timeUnit);
    }

    public void start(StartContext context) throws StartException {
        this.setDerive(this.derive);
        this.configConsumer.accept(this.poolConfig);
    }

    public void stop(StopContext context) {
        this.configConsumer.accept(null);
    }

    public StrictMaxPoolConfig getValue() {
        return this.poolConfig;
    }

    private int calcMaxFromWorkPools() {
        Integer max = this.maxThreadsSupplier != null ? this.maxThreadsSupplier.get() : null;
        return max != null && max > 0 ? max.intValue() : this.calcMaxFromCPUCount();
    }

    private int calcMaxFromCPUCount() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public synchronized void setMaxPoolSize(int newMax) {
        this.declaredMaxSize = newMax;
        if (this.derive == Derive.NONE) {
            this.poolConfig.setMaxPoolSize(newMax);
        }
    }

    public synchronized int getDerivedSize() {
        return this.poolConfig.getMaxPoolSize();
    }

    public synchronized void setDerive(Derive derive) {
        this.derive = derive;
        int max = this.declaredMaxSize;
        switch (derive) {
            case FROM_WORKER_POOLS: {
                max = this.calcMaxFromWorkPools();
                EjbLogger.ROOT_LOGGER.strictPoolDerivedFromWorkers(this.poolConfig.getPoolName(), max);
                break;
            }
            case FROM_CPU_COUNT: {
                max = this.calcMaxFromCPUCount();
                EjbLogger.ROOT_LOGGER.strictPoolDerivedFromCPUs(this.poolConfig.getPoolName(), max);
            }
        }
        this.poolConfig.setMaxPoolSize(max);
    }

    public void setTimeout(long timeout) {
        this.poolConfig.setTimeout(timeout);
    }

    public void setTimeoutUnit(TimeUnit timeUnit) {
        this.poolConfig.setTimeoutUnit(timeUnit);
    }

    public static enum Derive {
        NONE,
        FROM_WORKER_POOLS,
        FROM_CPU_COUNT;

    }
}

