/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.security.AccessController;
import org.wildfly.security.manager.action.GetContextClassLoaderAction;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;

final class TCCLUtils {
    private static final ClassLoader SAFE_CL;

    private TCCLUtils() {
    }

    static ClassLoader getAndSetSafeTCCL() {
        ClassLoader old;
        if (System.getSecurityManager() != null) {
            old = AccessController.doPrivileged(GetContextClassLoaderAction.getInstance());
            AccessController.doPrivileged(new SetContextClassLoaderAction(SAFE_CL));
        } else {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SAFE_CL);
        }
        return old;
    }

    static void resetTCCL(ClassLoader old) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContextClassLoaderAction(old));
        } else {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    static {
        ClassLoader safeClassLoader = TCCLUtils.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new ClassLoader(){};
        }
        SAFE_CL = safeClassLoader;
    }
}

