/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RelayHeader;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.Relayer2;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="RELAY2 protocol")
public class RELAY2
extends RELAY {
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging;
    @Property(description="Whether or not to relay multicast (dest=null) messages")
    protected boolean relay_multicasts = true;
    @Property(description="If true, a site master forwards messages received from other sites to randomly chosen members of the local site for load balancing, reducing work for itself")
    protected boolean can_forward_local_cluster;
    @Property(description="Number of millis to wait for topology detection", type=AttributeType.TIME)
    protected long topo_wait_time = 2000L;
    protected final ResponseCollector<String> topo_collector = new ResponseCollector();

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    public RELAY2 relayMulticasts(boolean flag) {
        this.relay_multicasts = flag;
        return this;
    }

    public boolean enableAddressTagging() {
        return this.enable_address_tagging;
    }

    public boolean relayMulticasts() {
        return this.relay_multicasts;
    }

    public boolean canForwardLocalCluster() {
        return this.can_forward_local_cluster;
    }

    public RELAY2 canForwardLocalCluster(boolean c) {
        this.can_forward_local_cluster = c;
        return this;
    }

    public long getTopoWaitTime() {
        return this.topo_wait_time;
    }

    public RELAY2 setTopoWaitTime(long t) {
        this.topo_wait_time = t;
        return this;
    }

    @Override
    public void configure() throws Exception {
        super.configure();
        if (!this.site_config.getForwards().isEmpty()) {
            this.log.warn(String.valueOf(this.local_addr) + ": forwarding routes are currently not supported and will be ignored. This will change with hierarchical routing (https://issues.redhat.com/browse/JGRP-1506)");
        }
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            ch.addAddressGenerator(() -> {
                ExtendedUUID retval = ExtendedUUID.randomUUID();
                if (this.can_become_site_master) {
                    retval.setFlag((short)2);
                }
                return retval;
            });
        }
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printTopology(boolean all_sites) {
        if (!all_sites) {
            return this.printLocalTopology();
        }
        if (this.relayer != null) {
            return this._printTopology(this.relayer);
        }
        Address site_master = this.site_masters != null && !this.site_masters.isEmpty() ? (Address)this.site_masters.get(0) : null;
        return site_master == null ? "not site-master" : this.fetchTopoFromSiteMaster(site_master);
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printLocalTopology() {
        StringBuilder sb = new StringBuilder(this.site).append("\n");
        for (Address mbr : this.members) {
            sb.append("  ").append(mbr);
            PhysicalAddress pa = this.getPhysicalAddress(mbr);
            if (pa != null) {
                sb.append(String.format(" (%s)", pa));
            }
            if (Objects.equals(mbr, this.local_addr)) {
                sb.append(" (me)");
            }
            if (this.site_masters.contains(mbr)) {
                sb.append(" // site master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Object down(Message msg) {
        SiteUUID sender;
        Address dest = msg.getDest();
        if (!(dest instanceof SiteAddress)) {
            return this.down_prot.down(msg);
        }
        SiteAddress target = (SiteAddress)dest;
        Address src = msg.getSrc();
        SiteUUID siteUUID = sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, NameCache.get(this.local_addr), this.site);
        if (this.local_addr instanceof ExtendedUUID) {
            ((ExtendedUUID)sender).addContents((ExtendedUUID)this.local_addr);
        }
        if (target.getSite().equals(this.site)) {
            if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_site_master) {
                this.forwardTo(this.local_addr, target, sender, msg, false);
            } else {
                this.deliverLocally(target, sender, msg);
            }
            return null;
        }
        if (!this.is_site_master) {
            long start = this.stats ? System.nanoTime() : 0L;
            Address site_master = this.pickSiteMaster(sender);
            if (site_master == null) {
                throw new IllegalStateException("site master is null");
            }
            this.forwardTo(site_master, target, sender, msg, this.max_site_masters == 1);
            if (this.stats) {
                this.forward_sm_time.add(System.nanoTime() - start);
                this.forward_to_site_master.increment();
            }
        } else {
            this.route(target, sender, msg);
        }
        return null;
    }

    @Override
    public Object up(Message msg) {
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        Address dest = msg.getDest();
        if (hdr == null) {
            if (dest == null && this.is_site_master && this.relay_multicasts && !msg.isFlagSet(Message.Flag.NO_RELAY)) {
                Address src = msg.getSrc();
                SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), NameCache.get(msg.getSrc()), this.site);
                if (src instanceof ExtendedUUID) {
                    sender.addContents((ExtendedUUID)src);
                }
                this.sendToBridges(sender, msg, this.site);
            }
            return this.up_prot.up(msg);
        }
        if (this.handleAdminMessage(hdr, msg.src())) {
            return null;
        }
        if (dest != null) {
            this.handleMessage(hdr, msg);
        } else {
            this.deliver(null, hdr.original_sender, msg);
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<SiteAddress> unreachable_sites = null;
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
            Address dest = msg.getDest();
            if (hdr == null) {
                if (dest != null || !this.is_site_master || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) continue;
                Address src = msg.getSrc();
                SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), NameCache.get(msg.getSrc()), this.site);
                if (src instanceof ExtendedUUID) {
                    sender.addContents((ExtendedUUID)src);
                }
                this.sendToBridges(sender, msg, this.site);
                continue;
            }
            if (this.handleAdminMessage(hdr, batch.sender())) {
                it.remove();
                continue;
            }
            it.remove();
            if (dest != null) {
                if (hdr.getType() == 2) {
                    boolean contains;
                    SiteAddress site_addr = (SiteAddress)hdr.final_dest;
                    String site_name = site_addr.getSite();
                    if (unreachable_sites == null) {
                        unreachable_sites = new ArrayList<SiteAddress>();
                    }
                    if (contains = unreachable_sites.stream().anyMatch(sa -> sa.getSite().equals(site_name))) continue;
                    unreachable_sites.add(site_addr);
                    continue;
                }
                this.handleMessage(hdr, msg);
                continue;
            }
            this.deliver(null, hdr.original_sender, msg);
        }
        if (unreachable_sites != null) {
            for (SiteAddress sa2 : unreachable_sites) {
                this.triggerSiteUnreachableEvent(sa2);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public void handleView(View view) {
        this.members = view.getMembers();
        int max_num_site_masters = this.max_site_masters;
        if (this.site_masters_ratio > 0.0) {
            max_num_site_masters = (int)Math.max((double)this.max_site_masters, this.site_masters_ratio * (double)view.size());
        }
        List old_site_masters = this.site_masters;
        List<Address> new_site_masters = RELAY2.determineSiteMasters(view, max_num_site_masters);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (!this.site_masters.isEmpty() && ((Address)this.site_masters.get(0)).equals(this.local_addr)) {
            this.broadcast_route_notifications = true;
        }
        if (become_site_master) {
            this.is_site_master = true;
            String bridge_name = "_" + NameCache.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            this.relayer = new Relayer2(this, this.log);
            Relayer2 tmp = (Relayer2)this.relayer;
            if (this.async_relay_creation) {
                this.timer.execute(() -> this.startRelayer(tmp, bridge_name));
            } else {
                this.startRelayer(tmp, bridge_name);
            }
            this.notifySiteMasterListener(true);
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.notifySiteMasterListener(false);
            this.log.trace(String.valueOf(this.local_addr) + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
        if (this.suppress_log_no_route != null) {
            this.suppress_log_no_route.removeExpired(this.suppress_time_no_route_errors);
        }
    }

    @Override
    protected void handleRelayMessage(Message msg) {
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        if (hdr == null) {
            this.log.warn("%s: received a message without a relay header; discarding it", this.local_addr);
            return;
        }
        if (hdr.final_dest != null) {
            Message message = msg;
            RelayHeader header = hdr;
            if (header.type == 1 && this.can_forward_local_cluster) {
                SiteUUID site_uuid = (SiteUUID)hdr.final_dest;
                UUID tmp = (UUID)Util.pickRandomElement(this.members);
                SiteUUID final_dest = new SiteUUID(tmp, site_uuid.getName(), site_uuid.getSite());
                if (!((Object)final_dest).equals(hdr.final_dest)) {
                    message = this.copy(msg);
                    header = new RelayHeader(1, final_dest, hdr.original_sender);
                    message.putHeader(this.id, header);
                }
            }
            this.handleMessage(header, message);
        } else {
            Message copy = this.copy(msg).setDest(null).setSrc(null).putHeader(this.id, hdr);
            this.down_prot.down(copy);
        }
    }

    protected boolean handleAdminMessage(RelayHeader hdr, Address sender) {
        switch (hdr.type) {
            case 4: 
            case 5: {
                if (this.route_status_listener != null) {
                    HashSet<String> tmp_sites = new HashSet<String>();
                    if (hdr.hasSites()) {
                        tmp_sites.addAll(hdr.getSites());
                    }
                    if (!tmp_sites.isEmpty()) {
                        String[] t = tmp_sites.toArray(new String[0]);
                        if (hdr.type == 4) {
                            this.route_status_listener.sitesUp(t);
                        } else {
                            this.route_status_listener.sitesDown(t);
                        }
                    }
                }
                return true;
            }
            case 6: {
                Message topo_rsp = new EmptyMessage(sender).putHeader(this.id, new RelayHeader(7).addToSites(this._printTopology(this.relayer)));
                this.down_prot.down(topo_rsp);
                return true;
            }
            case 7: {
                String rsp = hdr.sites != null && !hdr.sites.isEmpty() ? hdr.sites.iterator().next() : null;
                this.topo_collector.add(sender, rsp);
                return true;
            }
        }
        return false;
    }

    protected void handleMessage(RelayHeader hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg);
                break;
            }
            case 2: {
                this.triggerSiteUnreachableEvent((SiteAddress)hdr.final_dest);
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, Message msg) {
        String target_site = dest.getSite();
        if (target_site.equals(this.site)) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_site_master) {
                this.deliver(dest, sender, msg);
            } else {
                this.deliverLocally(dest, sender, msg);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn(String.valueOf(this.local_addr) + ": not site master; dropping message");
            return;
        }
        Route route = tmp.getRoute(target_site, sender);
        if (route == null) {
            if (this.suppress_log_no_route != null) {
                this.suppress_log_no_route.log(SuppressLog.Level.error, target_site, this.suppress_time_no_route_errors, sender, target_site);
            } else {
                this.log.error(Util.getMessage("RelayNoRouteToSite"), this.local_addr, target_site);
            }
            this.sendSiteUnreachableTo(msg.getSrc(), target_site);
        } else {
            route.send(dest, sender, msg);
        }
    }

    protected void sendToBridges(Address sender, Message msg, String ... excluded_sites) {
        List<Route> routes;
        Relayer tmp = this.relayer;
        List<Route> list = routes = tmp != null ? tmp.getRoutes(excluded_sites) : null;
        if (routes == null) {
            return;
        }
        for (Route route : routes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(this.local_addr) + ": relaying multicast message from " + String.valueOf(sender) + " via route " + String.valueOf(route));
            }
            try {
                route.send(null, sender, msg);
            }
            catch (Exception ex) {
                this.log.error(String.valueOf(this.local_addr) + ": failed relaying message from " + String.valueOf(sender) + " via route " + String.valueOf(route), ex);
            }
        }
    }

    protected void sendSiteUnreachableTo(Address src, String target_site) {
        if (src == null || src.equals(this.local_addr)) {
            this.triggerSiteUnreachableEvent(new SiteMaster(target_site));
            return;
        }
        Message msg = new EmptyMessage(src).setFlag(Message.Flag.OOB).putHeader(this.id, new RelayHeader(2, new SiteMaster(target_site), null));
        this.down_prot.down(msg);
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, Message msg, boolean forward_to_current_coord) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.valueOf(this.local_addr) + ": forwarding message to final destination " + String.valueOf(final_dest) + " to " + String.valueOf(forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        Message copy = this.copy(msg).setDest(next_dest).setSrc(null);
        RelayHeader hdr = new RelayHeader(1, final_dest, original_sender);
        copy.putHeader(this.id, hdr);
        this.down_prot.down(copy);
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, Message msg) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.pickSiteMaster(sender);
                if (local_dest == null) {
                    throw new IllegalStateException("site master was null");
                }
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.valueOf(this.local_addr) + ": delivering message to " + String.valueOf(dest) + " in local cluster");
        }
        long start = this.stats ? System.nanoTime() : 0L;
        this.forwardTo(local_dest, dest, sender, msg, send_to_coord);
        if (this.stats) {
            this.forward_to_local_mbr_time.add(System.nanoTime() - start);
            this.forward_to_local_mbr.increment();
        }
    }

    protected void deliver(Address dest, Address sender, Message msg) {
        try {
            Message copy = this.copy(msg).setDest(dest).setSrc(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(this.local_addr) + ": delivering message from " + String.valueOf(sender));
            }
            this.up_prot.up(copy);
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDeliveringMessage"), e);
        }
    }

    protected void startRelayer(Relayer2 rel, String bridge_name) {
        try {
            this.log.trace(String.valueOf(this.local_addr) + ": became site master; starting bridges");
            rel.start(this.site_config.getBridges(), bridge_name, this.site);
        }
        catch (Throwable t) {
            this.log.error(String.valueOf(this.local_addr) + ": failed starting relayer", t);
        }
    }

    protected String _printTopology(Relayer rel) {
        HashMap<Address, String> local_sitemasters = new HashMap<Address, String>();
        Collection<String> all_sites = rel.getSiteNames();
        ArrayList<Supplier<Boolean>> topo_reqs = new ArrayList<Supplier<Boolean>>();
        for (String site_name : all_sites) {
            Route r = rel.getRoute(site_name);
            JChannel bridge = r.bridge();
            Address site_master = r.site_master;
            if (Objects.equals(site_master, r.bridge().getAddress())) {
                local_sitemasters.put(site_master, this.printLocalTopology());
                continue;
            }
            local_sitemasters.put(site_master, null);
            topo_reqs.add(() -> this.sendTopoReq(bridge, site_master));
        }
        this.topo_collector.reset(local_sitemasters.keySet());
        local_sitemasters.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.topo_collector.add((Address)e.getKey(), (String)e.getValue()));
        topo_reqs.forEach(Supplier::get);
        this.topo_collector.waitForAllResponses(this.topo_wait_time);
        Map<Address, String> rsps = this.topo_collector.getResults();
        if (rsps == null || rsps.isEmpty()) {
            return "n/a";
        }
        return String.join((CharSequence)"\n", rsps.values());
    }

    protected boolean sendTopoReq(JChannel bridge, Address dest) {
        Message topo_req = new EmptyMessage(dest).putHeader(this.id, new RelayHeader(6));
        try {
            bridge.send(topo_req);
            return true;
        }
        catch (Exception e) {
            this.log.warn("%s: failed sending TOPO-REQ message to %s: %s", bridge.getAddress(), dest, e);
            return false;
        }
    }

    protected String fetchTopoFromSiteMaster(Address sm) {
        this.topo_collector.reset(sm);
        Message topo_req = new EmptyMessage(sm).putHeader(this.id, new RelayHeader(6));
        this.down_prot.down(topo_req);
        this.topo_collector.waitForAllResponses(this.topo_wait_time);
        Map<Address, String> rsps = this.topo_collector.getResults();
        return rsps != null ? rsps.get(sm) : null;
    }
}

