/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.flash.FlashELResolver;
import com.sun.faces.el.CompositeComponentAttributesELResolver;
import com.sun.faces.el.EmptyStringToNullELResolver;
import com.sun.faces.el.FacesCompositeELResolver;
import com.sun.faces.el.FacesResourceBundleELResolver;
import com.sun.faces.el.ResourceELResolver;
import com.sun.faces.el.ScopedAttributeELResolver;
import com.sun.faces.util.Cache;
import com.sun.faces.util.LRUCache;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.ValueExpression;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ELUtils {
    private static final int compositeComponentEvaluationCacheMaxSize = 1000;
    private static final Pattern COMPOSITE_COMPONENT_EXPRESSION = Pattern.compile(".(?:[ ]+|[\\[{,(])cc[.].+[}]");
    private static final Matcher COMPOSITE_COMPONENT_EXPRESSION_MATCHER = COMPOSITE_COMPONENT_EXPRESSION.matcher("");
    private static final Cache.Factory<String, Boolean> isCompositeExpressionInit = new Cache.Factory<String, Boolean>(){

        @Override
        public Boolean newInstance(String expression) {
            return expression == null ? Boolean.FALSE.booleanValue() : COMPOSITE_COMPONENT_EXPRESSION_MATCHER.reset(expression).find();
        }
    };
    private static final LRUCache<String, Boolean> compositeComponentEvaluationCache = new LRUCache<String, Boolean>(isCompositeExpressionInit, 1000);
    private static final Pattern COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS = Pattern.compile("(?:[ ]+|[\\[{,(])cc[.]attrs[.]\\w+[(].+[)]");
    private static final Pattern METHOD_EXPRESSION_LOOKUP = Pattern.compile(".[{]cc[.]attrs[.]\\w+[}]");
    public static final ArrayELResolver ARRAY_RESOLVER = new ArrayELResolver();
    public static final BeanELResolver BEAN_RESOLVER = new BeanELResolver();
    public static final FacesResourceBundleELResolver FACES_BUNDLE_RESOLVER = new FacesResourceBundleELResolver();
    public static final FlashELResolver FLASH_RESOLVER = new FlashELResolver();
    public static final ListELResolver LIST_RESOLVER = new ListELResolver();
    public static final MapELResolver MAP_RESOLVER = new MapELResolver();
    public static final ResourceBundleELResolver BUNDLE_RESOLVER = new ResourceBundleELResolver();
    public static final ScopedAttributeELResolver SCOPED_RESOLVER = new ScopedAttributeELResolver();
    public static final ResourceELResolver RESOURCE_RESOLVER = new ResourceELResolver();
    public static final CompositeComponentAttributesELResolver COMPOSITE_COMPONENT_ATTRIBUTES_EL_RESOLVER = new CompositeComponentAttributesELResolver();
    public static final EmptyStringToNullELResolver EMPTY_STRING_TO_NULL_RESOLVER = new EmptyStringToNullELResolver();

    private ELUtils() {
        throw new IllegalStateException();
    }

    public static boolean isCompositeComponentExpr(String expression) {
        return compositeComponentEvaluationCache.get(expression);
    }

    public static boolean isCompositeComponentMethodExprLookup(String expression) {
        return METHOD_EXPRESSION_LOOKUP.matcher(expression).matches();
    }

    public static boolean isCompositeComponentLookupWithArgs(String expression) {
        return COMPOSITE_COMPONENT_LOOKUP_WITH_ARGS.matcher(expression).find();
    }

    public static void buildFacesResolver(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        ELUtils.checkNotNull(composite, associate);
        ELUtils.addCDIELResolver(composite);
        composite.add(FLASH_RESOLVER);
        composite.addPropertyELResolver(COMPOSITE_COMPONENT_ATTRIBUTES_EL_RESOLVER);
        ELUtils.addELResolvers(composite, associate.getELResolversFromFacesConfig());
        composite.add((ELResolver)associate.getApplicationELResolvers());
        if (WebConfiguration.getInstance().isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.InterpretEmptyStringSubmittedValuesAsNull)) {
            composite.addPropertyELResolver(EMPTY_STRING_TO_NULL_RESOLVER);
        }
        composite.addPropertyELResolver(RESOURCE_RESOLVER);
        composite.addPropertyELResolver((ELResolver)BUNDLE_RESOLVER);
        composite.addRootELResolver(FACES_BUNDLE_RESOLVER);
        ELUtils.addEL3_0_Resolvers(composite, associate);
        composite.addPropertyELResolver((ELResolver)MAP_RESOLVER);
        composite.addPropertyELResolver((ELResolver)LIST_RESOLVER);
        composite.addPropertyELResolver((ELResolver)ARRAY_RESOLVER);
        composite.addPropertyELResolver((ELResolver)BEAN_RESOLVER);
        composite.addRootELResolver(SCOPED_RESOLVER);
    }

    private static void checkNotNull(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        if (associate == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "associate"));
        }
        if (composite == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "composite"));
        }
    }

    private static void addCDIELResolver(FacesCompositeELResolver composite) {
        composite.add(Util.getCdiBeanManager(FacesContext.getCurrentInstance()).getELResolver());
    }

    private static void addEL3_0_Resolvers(FacesCompositeELResolver composite, ApplicationAssociate associate) {
        ExpressionFactory expressionFactory = associate.getExpressionFactory();
        Method getStreamELResolverMethod = ReflectionUtils.lookupMethod(ExpressionFactory.class, "getStreamELResolver", RIConstants.EMPTY_CLASS_ARGS);
        if (getStreamELResolverMethod != null) {
            try {
                ELResolver streamELResolver = (ELResolver)getStreamELResolverMethod.invoke((Object)expressionFactory, (Object[])null);
                if (streamELResolver != null) {
                    composite.addRootELResolver(streamELResolver);
                    composite.addRootELResolver((ELResolver)ReflectionUtils.newInstance("jakarta.el.StaticFieldELResolver"));
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static Object evaluateValueExpression(ValueExpression expression, ELContext elContext) {
        if (expression.isLiteralText()) {
            return expression.getExpressionString();
        }
        return expression.getValue(elContext);
    }

    public static ValueExpression createValueExpression(String expression) {
        return ELUtils.createValueExpression(expression, Object.class);
    }

    public static ValueExpression createValueExpression(String expression, Class<?> expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, expectedType);
    }

    public static Object coerce(Object value, Class<?> toType) {
        return FacesContext.getCurrentInstance().getApplication().getExpressionFactory().coerceToType(value, toType);
    }

    private static void addELResolvers(CompositeELResolver target, List<ELResolver> resolvers) {
        if (resolvers != null && !resolvers.isEmpty()) {
            for (ELResolver resolver : resolvers) {
                target.add(resolver);
            }
        }
    }

    public static ExpressionFactory getDefaultExpressionFactory(FacesContext facesContext) {
        if (facesContext == null) {
            return null;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        if (extContext == null) {
            return null;
        }
        return ELUtils.getDefaultExpressionFactory(ApplicationAssociate.getInstance(extContext), facesContext);
    }

    public static ExpressionFactory getDefaultExpressionFactory(ApplicationAssociate associate, FacesContext facesContext) {
        if (associate == null) {
            return null;
        }
        return associate.getExpressionFactory();
    }
}

