/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.group;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.infinispan.protostream.descriptors.WireType;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.infinispan.group.IpAddressBuilder;

public enum IpAddressMarshaller implements FieldSetMarshaller.Supplied<IpAddress, IpAddressBuilder>
{
    INSTANCE;

    static final InetAddress DEFAULT_ADDRESS;
    private static final int DEFAULT_PORT = 7600;
    private static final int ADDRESS_INDEX = 0;
    private static final int PORT_INDEX = 1;
    private static final int FIELDS = 2;

    public IpAddressBuilder createInitialValue() {
        return new DefaultIpAddressBuilder();
    }

    public int getFields() {
        return 2;
    }

    public IpAddressBuilder readFrom(ProtoStreamReader reader, int index, WireType type, IpAddressBuilder builder) throws IOException {
        switch (index) {
            case 0: {
                return builder.setAddress(reader.readByteArray());
            }
            case 1: {
                return builder.setPort(reader.readUInt32());
            }
        }
        reader.skipField(type);
        return builder;
    }

    public void writeTo(ProtoStreamWriter writer, IpAddress address) throws IOException {
        int port;
        byte[] bytes = address.getIpAddress().getAddress();
        if (!Arrays.equals(bytes, DEFAULT_ADDRESS.getAddress())) {
            writer.writeBytes(0, bytes);
        }
        if ((port = address.getPort()) != 7600) {
            writer.writeUInt32(1, port);
        }
    }

    static {
        DEFAULT_ADDRESS = InetAddress.getLoopbackAddress();
    }

    static class DefaultIpAddressBuilder
    implements IpAddressBuilder {
        private InetAddress address = DEFAULT_ADDRESS;
        private int port = 7600;

        DefaultIpAddressBuilder() {
        }

        @Override
        public IpAddressBuilder setAddress(byte[] address) throws UnknownHostException {
            this.address = InetAddress.getByAddress(address);
            return this;
        }

        @Override
        public IpAddressBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        @Override
        public IpAddress get() {
            return new IpAddress(this.address, this.port);
        }
    }
}

