/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.SubExplodedDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class EarStructureProcessor
implements DeploymentUnitProcessor {
    private static final String JAR_EXTENSION = ".jar";
    private static final String WAR_EXTENSION = ".war";
    private static final String SAR_EXTENSION = ".sar";
    private static final String RAR_EXTENSION = ".rar";
    private static final List<String> CHILD_ARCHIVE_EXTENSIONS = new ArrayList<String>();
    private static final SuffixMatchFilter CHILD_ARCHIVE_FILTER;
    private static final String DEFAULT_LIB_DIR = "lib";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String xmlLibDirName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile virtualFile = deploymentRoot.getRoot();
        deploymentRoot.putAttachment(org.jboss.as.server.deployment.Attachments.INDEX_RESOURCE_ROOT, (Object)false);
        ModuleRootMarker.mark((ResourceRoot)deploymentRoot, (boolean)false);
        String libDirName = DEFAULT_LIB_DIR;
        boolean appXmlPresent = deploymentRoot.getRoot().getChild("META-INF/application.xml").exists();
        EarMetaData earMetaData = (EarMetaData)deploymentUnit.getAttachment(Attachments.EAR_METADATA);
        if (earMetaData != null && (xmlLibDirName = earMetaData.getLibraryDirectory()) != null) {
            if (xmlLibDirName.length() == 1 && xmlLibDirName.charAt(0) == '/') {
                throw EeLogger.ROOT_LOGGER.rootAsLibraryDirectory();
            }
            libDirName = xmlLibDirName;
        }
        Map overlays = (Map)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
        try {
            ResourceRoot childResource;
            VirtualFile libDir;
            if (!libDirName.isEmpty()) {
                libDir = virtualFile.getChild(libDirName);
                if (libDir.exists()) {
                    List libArchives = libDir.getChildren((VirtualFileFilter)CHILD_ARCHIVE_FILTER);
                    for (VirtualFile child : libArchives) {
                        MountHandle mountHandle;
                        String relativeName = child.getPathNameRelativeTo(deploymentRoot.getRoot());
                        MountedDeploymentOverlay overlay = (MountedDeploymentOverlay)overlays.get(relativeName);
                        if (overlay != null) {
                            overlay.remountAsZip(false);
                            mountHandle = MountHandle.create(null);
                        } else {
                            Closeable closable = child.isFile() ? EarStructureProcessor.mount(child, false) : null;
                            mountHandle = MountHandle.create((Closeable)closable);
                        }
                        childResource = new ResourceRoot(child, mountHandle);
                        if (!child.getName().toLowerCase(Locale.ENGLISH).endsWith(JAR_EXTENSION)) continue;
                        ModuleRootMarker.mark((ResourceRoot)childResource);
                        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS, (Object)childResource);
                    }
                }
            } else {
                libDir = null;
            }
            ArrayList childArchives = new ArrayList(virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(CHILD_ARCHIVE_EXTENSIONS, new VisitorAttributes(){

                public boolean isLeavesOnly() {
                    return false;
                }

                public boolean isRecurse(VirtualFile file) {
                    if (file.equals(libDir)) {
                        return false;
                    }
                    for (String suffix : CHILD_ARCHIVE_EXTENSIONS) {
                        if (!file.getName().endsWith(suffix)) continue;
                        return false;
                    }
                    return true;
                }
            })));
            if (!appXmlPresent) {
                for (VirtualFile child : childArchives) {
                    boolean isWarFile = child.getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
                    boolean isRarFile = child.getName().toLowerCase(Locale.ENGLISH).endsWith(RAR_EXTENSION);
                    this.createResourceRoot(deploymentUnit, child, isWarFile || isRarFile, isWarFile);
                }
            } else {
                HashSet<VirtualFile> subDeploymentFiles = new HashSet<VirtualFile>();
                for (ModuleMetaData module : earMetaData.getModules()) {
                    String alternativeDD;
                    VirtualFile moduleParentFile;
                    if (module.getFileName().endsWith(".xml")) {
                        throw EeLogger.ROOT_LOGGER.unsupportedModuleType(module.getFileName());
                    }
                    VirtualFile moduleFile = virtualFile.getChild(module.getFileName());
                    if (!moduleFile.exists()) {
                        throw EeLogger.ROOT_LOGGER.cannotProcessEarModule(virtualFile, module.getFileName());
                    }
                    if (libDir != null && (moduleParentFile = moduleFile.getParent()) != null && libDir.equals(moduleParentFile)) {
                        throw EeLogger.ROOT_LOGGER.earModuleChildOfLibraryDirectory(libDirName, module.getFileName());
                    }
                    subDeploymentFiles.add(moduleFile);
                    boolean webArchive = module.getType() == ModuleMetaData.ModuleType.Web;
                    childResource = this.createResourceRoot(deploymentUnit, moduleFile, true, webArchive);
                    childResource.putAttachment(Attachments.MODULE_META_DATA, (Object)module);
                    if (!webArchive) {
                        ModuleRootMarker.mark((ResourceRoot)childResource);
                    }
                    if ((alternativeDD = module.getAlternativeDD()) == null || alternativeDD.trim().length() <= 0) continue;
                    VirtualFile alternateDeploymentDescriptor = deploymentRoot.getRoot().getChild(alternativeDD);
                    if (!alternateDeploymentDescriptor.exists()) {
                        throw EeLogger.ROOT_LOGGER.alternateDeploymentDescriptor(alternateDeploymentDescriptor, moduleFile);
                    }
                    switch (module.getType()) {
                        case Client: {
                            childResource.putAttachment(Attachments.ALTERNATE_CLIENT_DEPLOYMENT_DESCRIPTOR, (Object)alternateDeploymentDescriptor);
                            break;
                        }
                        case Connector: {
                            childResource.putAttachment(Attachments.ALTERNATE_CONNECTOR_DEPLOYMENT_DESCRIPTOR, (Object)alternateDeploymentDescriptor);
                            break;
                        }
                        case Ejb: {
                            childResource.putAttachment(Attachments.ALTERNATE_EJB_DEPLOYMENT_DESCRIPTOR, (Object)alternateDeploymentDescriptor);
                            break;
                        }
                        case Web: {
                            childResource.putAttachment(Attachments.ALTERNATE_WEB_DEPLOYMENT_DESCRIPTOR, (Object)alternateDeploymentDescriptor);
                            break;
                        }
                        case Service: {
                            throw EeLogger.ROOT_LOGGER.unsupportedModuleType(module.getFileName());
                        }
                    }
                }
                for (VirtualFile child : childArchives) {
                    String fileName;
                    if (subDeploymentFiles.contains(child) || !(fileName = child.getName().toLowerCase(Locale.ENGLISH)).endsWith(SAR_EXTENSION) && !fileName.endsWith(JAR_EXTENSION)) continue;
                    this.createResourceRoot(deploymentUnit, child, false, false);
                }
            }
        }
        catch (IOException e) {
            throw EeLogger.ROOT_LOGGER.failedToProcessChild(e, virtualFile);
        }
    }

    private static Closeable mount(VirtualFile moduleFile, boolean explode) throws IOException {
        return explode ? VFS.mountZipExpanded((VirtualFile)moduleFile, (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider()) : VFS.mountZip((File)moduleFile.getPhysicalFile(), (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider());
    }

    private ResourceRoot createResourceRoot(DeploymentUnit deploymentUnit, VirtualFile file, boolean markAsSubDeployment, boolean explodeDuringMount) throws IOException {
        boolean war = file.getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
        Closeable closable = file.isFile() ? EarStructureProcessor.mount(file, explodeDuringMount) : this.exportExplodedWar(war, file, deploymentUnit);
        MountHandle mountHandle = MountHandle.create((Closeable)closable);
        ResourceRoot resourceRoot = new ResourceRoot(file, mountHandle);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS, (Object)resourceRoot);
        if (markAsSubDeployment) {
            SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
        }
        if (war) {
            resourceRoot.putAttachment(org.jboss.as.server.deployment.Attachments.INDEX_RESOURCE_ROOT, (Object)false);
            SubExplodedDeploymentMarker.mark((ResourceRoot)resourceRoot);
        }
        return resourceRoot;
    }

    private Closeable exportExplodedWar(boolean war, VirtualFile file, DeploymentUnit deploymentUnit) throws IOException {
        if (this.isExplodedWarInArchiveEar(war, file, deploymentUnit)) {
            File warContent = file.getPhysicalFile();
            VFSUtils.recursiveCopy((VirtualFile)file, (File)warContent.getParentFile());
            return VFS.mountReal((File)warContent, (VirtualFile)file);
        }
        return null;
    }

    private boolean isExplodedWarInArchiveEar(boolean war, VirtualFile file, DeploymentUnit deploymentUnit) {
        return war && !file.isFile() && deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_CONTENTS) && ((VirtualFile)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_CONTENTS)).isFile();
    }

    public void undeploy(DeploymentUnit context) {
        List children = (List)context.removeAttachment(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
        if (children != null) {
            for (ResourceRoot childRoot : children) {
                VFSUtils.safeClose((Closeable)childRoot.getMountHandle());
            }
        }
    }

    static {
        CHILD_ARCHIVE_EXTENSIONS.add(JAR_EXTENSION);
        CHILD_ARCHIVE_EXTENSIONS.add(WAR_EXTENSION);
        CHILD_ARCHIVE_EXTENSIONS.add(SAR_EXTENSION);
        CHILD_ARCHIVE_EXTENSIONS.add(RAR_EXTENSION);
        CHILD_ARCHIVE_FILTER = new SuffixMatchFilter(CHILD_ARCHIVE_EXTENSIONS, new VisitorAttributes(){

            public boolean isLeavesOnly() {
                return false;
            }
        });
    }
}

