/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.function.Function;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.ejb.bean.BeanDeploymentMarshallingContext;
import org.wildfly.clustering.ejb.client.EJBProxyObjectTable;
import org.wildfly.clustering.ejb.client.EJBProxyResolver;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.DynamicExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleSerializabilityChecker;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public enum BeanMarshallerFactory implements Function<BeanDeploymentMarshallingContext, ByteBufferMarshaller>
{
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(BeanDeploymentMarshallingContext context) {
            SimpleMarshallingConfigurationRepository repository = new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)context);
            return new JBossByteBufferMarshaller((MarshallingConfigurationRepository)repository, (ClassLoader)context.getModule().getClassLoader());
        }
    };


    static enum MarshallingVersion implements Function<BeanDeploymentMarshallingContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(BeanDeploymentMarshallingContext context) {
                Module module = context.getModule();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new SimpleSerializabilityChecker(context.getBeanClasses()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
                config.setObjectTable((ObjectTable)new EJBProxyObjectTable());
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(BeanDeploymentMarshallingContext context) {
                Module module = context.getModule();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new SimpleSerializabilityChecker(context.getBeanClasses()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
                config.setObjectResolver((ObjectResolver)new EJBProxyResolver());
                config.setObjectTable((ObjectTable)new DynamicExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

