/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.amqp.ssl.context;

import jakarta.enterprise.inject.spi.Extension;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.common.Assert;
import org.wildfly.microprofile.reactive.messaging.common.security.BaseReactiveMessagingSslConfigProcessor;
import org.wildfly.microprofile.reactive.messaging.config.amqp.ssl.context.AmqpReactiveMessagingCdiExtension;

class AmqpReactiveMessagingSslConfigProcessor
extends BaseReactiveMessagingSslConfigProcessor {
    private static final String CONNECTOR_NAME = "smallrye-amqp";
    private static final String CDI_BEAN_PROPERTY_SUFFIX = "client-ssl-context-name";
    private static final String CDI_BEAN_NAME_PREFIX = "cdi-ssl-context-bean-";

    AmqpReactiveMessagingSslConfigProcessor() {
        super(CONNECTOR_NAME);
    }

    protected BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext createSecurityDeploymentContext() {
        return new AmqpSecurityDeploymentContext();
    }

    private class AmqpSecurityDeploymentContext
    implements BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext {
        private static final String NO_SSL_CONTEXT = "none";
        private final Map<String, String> addedProperties = new HashMap<String, String>();
        private String globalSslContext;
        private Map<String, String> sslContextsPerConnector = new HashMap<String, String>();

        private AmqpSecurityDeploymentContext() {
        }

        public void setGlobalSslContext(String globalPropertyPrefix, String sslContext) {
            this.globalSslContext = sslContext;
        }

        public void setConnectorSslContext(String connectorPrefix, String sslContext) {
            this.sslContextsPerConnector.put(connectorPrefix, sslContext == null ? NO_SSL_CONTEXT : sslContext);
        }

        public Map<String, String> complete(DeploymentPhaseContext phaseContext) {
            if (this.globalSslContext == null && this.sslContextsPerConnector.isEmpty()) {
                return this.addedProperties;
            }
            AmqpReactiveMessagingCdiExtension cdiExtension = this.registerCdiExtension(phaseContext);
            HashSet<String> sslContextBeans = new HashSet<String>();
            for (Map.Entry<String, String> connectorEntry : this.sslContextsPerConnector.entrySet()) {
                String sslContext = connectorEntry.getValue();
                if (NO_SSL_CONTEXT == sslContext) {
                    if (this.globalSslContext == null) continue;
                    this.addCdiBeanAndProperty(cdiExtension, sslContextBeans, connectorEntry.getKey(), this.globalSslContext);
                    continue;
                }
                this.addCdiBeanAndProperty(cdiExtension, sslContextBeans, connectorEntry.getKey(), connectorEntry.getValue());
            }
            return this.addedProperties;
        }

        private void addCdiBeanAndProperty(AmqpReactiveMessagingCdiExtension cdiExtension, Set<String> sslContextBeans, String connectorPrefix, String sslContextName) {
            String cdiBeanPropertyName = connectorPrefix + AmqpReactiveMessagingSslConfigProcessor.CDI_BEAN_PROPERTY_SUFFIX;
            String cdiBeanName = AmqpReactiveMessagingSslConfigProcessor.CDI_BEAN_NAME_PREFIX + sslContextName;
            this.addedProperties.put(cdiBeanPropertyName, cdiBeanName);
            if (sslContextBeans.add(cdiBeanName)) {
                cdiExtension.addSslContextBean(cdiBeanName, sslContextName);
            }
        }

        private AmqpReactiveMessagingCdiExtension registerCdiExtension(DeploymentPhaseContext phaseContext) {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            AmqpReactiveMessagingCdiExtension extension = new AmqpReactiveMessagingCdiExtension();
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            if (support.hasCapability("org.wildfly.weld")) {
                try {
                    WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
                    weldCapability.registerExtensionInstance((Extension)extension, deploymentUnit);
                }
                catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
                    Assert.unreachableCode();
                }
            }
            return extension;
        }
    }
}

