/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.util.Counter;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneCounterAdapter;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public class CollectorSet {
    private final Collector composed;
    private final Map<CollectorKey<?>, Collector> components;

    private CollectorSet(Collector composed, Map<CollectorKey<?>, Collector> components) {
        this.composed = composed;
        this.components = components;
    }

    public Collector getComposed() {
        return this.composed;
    }

    public <C extends Collector> C get(CollectorKey<C> key) {
        return (C)this.components.get(key);
    }

    public static class Builder {
        private final CollectorExecutionContext executionContext;
        private final TimeoutManager timeoutManager;
        private final Map<CollectorKey<?>, Collector> components = new LinkedHashMap();

        public Builder(CollectorExecutionContext executionContext, TimeoutManager timeoutManager) {
            this.executionContext = executionContext;
            this.timeoutManager = timeoutManager;
        }

        public <C extends Collector> void add(CollectorKey<C> key, C collector) {
            this.components.put(key, collector);
        }

        public void addAll(Set<CollectorFactory<?>> collectorFactories) throws IOException {
            for (CollectorFactory<?> collectorFactory : collectorFactories) {
                Object collector = collectorFactory.createCollector(this.executionContext);
                this.components.put(collectorFactory.getCollectorKey(), (Collector)collector);
            }
        }

        public CollectorSet build() {
            if (this.components.isEmpty()) {
                return new CollectorSet(null, this.components);
            }
            Collector composed = this.wrapTimeLimitingCollectorIfNecessary(this.components.size() == 1 ? this.components.values().iterator().next() : MultiCollector.wrap(this.components.values()), this.timeoutManager);
            return new CollectorSet(composed, this.components);
        }

        private Collector wrapTimeLimitingCollectorIfNecessary(Collector collector, TimeoutManager timeoutManager) {
            Deadline deadline = timeoutManager.deadlineOrNull();
            if (deadline != null) {
                TimeLimitingCollector wrapped = new TimeLimitingCollector(collector, (Counter)new LuceneCounterAdapter(timeoutManager.timingSource()), deadline.checkRemainingTimeMillis());
                wrapped.setBaseline(timeoutManager.timeoutBaseline());
                return wrapped;
            }
            return collector;
        }
    }
}

