/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneReversibleSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;

class LuceneScoreSort
extends AbstractLuceneReversibleSort {
    private static final SortField FIELD_SCORE_ASC = new SortField(null, SortField.Type.SCORE, true);

    LuceneScoreSort(Builder builder) {
        super(builder);
    }

    @Override
    public void toSortFields(LuceneSearchSortCollector collector) {
        if (this.order == SortOrder.ASC) {
            collector.collectSortField(FIELD_SCORE_ASC);
        } else {
            collector.collectSortField(SortField.FIELD_SCORE);
        }
    }

    static class Builder
    extends AbstractLuceneReversibleSort.AbstractBuilder
    implements ScoreSortBuilder {
        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public SearchSort build() {
            return new LuceneScoreSort(this);
        }
    }
}

