/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.spi;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.common.timing.Deadline;

public final class ElasticsearchRequest {
    private final String method;
    private final String path;
    private final Map<String, String> parameters;
    private final List<JsonObject> bodyParts;
    private final Deadline deadline;

    public static Builder put() {
        return new Builder("PUT");
    }

    public static Builder get() {
        return new Builder("GET");
    }

    public static Builder post() {
        return new Builder("POST");
    }

    public static Builder delete() {
        return new Builder("DELETE");
    }

    public static Builder builder(String method) {
        return new Builder(method);
    }

    private ElasticsearchRequest(Builder builder) {
        this.method = builder.method;
        this.path = builder.pathBuilder.toString();
        this.parameters = builder.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(builder.parameters);
        this.bodyParts = builder.bodyParts == null ? Collections.emptyList() : Collections.unmodifiableList(builder.bodyParts);
        this.deadline = builder.deadline;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public List<JsonObject> bodyParts() {
        return this.bodyParts;
    }

    public Deadline deadline() {
        return this.deadline;
    }

    public String toString() {
        return new StringJoiner(", ", ElasticsearchRequest.class.getSimpleName() + "[", "]").add("method='" + this.method + "'").add("path='" + this.path + "'").add("parameters=" + this.parameters).add("bodyParts=" + this.bodyParts).add("deadline=" + this.deadline).toString();
    }

    public static final class Builder {
        private static final char PATH_SEPARATOR = '/';
        private final String method;
        private final StringBuilder pathBuilder = new StringBuilder(20);
        private Map<String, String> parameters;
        private List<JsonObject> bodyParts;
        private Deadline deadline;

        private Builder(String method) {
            this.method = method;
        }

        public Builder wholeEncodedPath(String path) {
            this.pathBuilder.setLength(0);
            this.pathBuilder.append(path);
            return this;
        }

        public Builder pathComponent(URLEncodedString pathComponent) {
            this.pathBuilder.append('/').append(pathComponent.encoded);
            return this;
        }

        public Builder multiValuedPathComponent(Iterable<URLEncodedString> indexNames) {
            boolean first = true;
            for (URLEncodedString name : indexNames) {
                if (!first) {
                    this.pathBuilder.append(',');
                } else {
                    this.pathBuilder.append('/');
                    first = false;
                }
                this.pathBuilder.append(name.encoded);
            }
            return this;
        }

        public Builder param(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, String>();
            }
            this.parameters.put(name, value);
            return this;
        }

        public Builder param(String name, int value) {
            return this.param(name, String.valueOf(value));
        }

        public Builder param(String name, long value) {
            return this.param(name, String.valueOf(value));
        }

        public Builder param(String name, boolean value) {
            return this.param(name, String.valueOf(value));
        }

        public Builder multiValuedParam(String name, Collection<String> values) {
            return this.param(name, String.join((CharSequence)",", values));
        }

        public Builder body(JsonObject object) {
            if (this.bodyParts == null) {
                this.bodyParts = new ArrayList<JsonObject>();
            }
            this.bodyParts.add(object);
            return this;
        }

        public Builder deadline(Deadline deadline) {
            this.deadline = deadline;
            return this;
        }

        public ElasticsearchRequest build() {
            return new ElasticsearchRequest(this);
        }
    }
}

