/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.DeleteWork;
import org.hibernate.search.backend.elasticsearch.work.impl.IndexWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class ElasticsearchIndexIndexer
implements IndexIndexer {
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public ElasticsearchIndexIndexer(ElasticsearchWorkFactory workFactory, ElasticsearchSerialWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, OperationSubmitter operationSubmitter) {
        return this.index(referenceProvider, documentContributor, refreshStrategy, operationSubmitter);
    }

    public CompletableFuture<?> addOrUpdate(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, OperationSubmitter operationSubmitter) {
        return this.index(referenceProvider, documentContributor, refreshStrategy, operationSubmitter);
    }

    public CompletableFuture<?> delete(DocumentReferenceProvider referenceProvider, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy, OperationSubmitter operationSubmitter) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        DeleteWork work = ((DeleteWork.Builder)this.workFactory.delete(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey).refresh(refreshStrategy)).build();
        return this.orchestrator.submit(work, operationSubmitter);
    }

    private CompletableFuture<?> index(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentRefreshStrategy refreshStrategy, OperationSubmitter operationSubmitter) {
        String id = referenceProvider.identifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.routingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        IndexWork work = ((IndexWork.Builder)this.workFactory.index(this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), this.indexManagerContext.getElasticsearchIndexWriteName(), elasticsearchId, routingKey, document).refresh(refreshStrategy)).build();
        return this.orchestrator.submit(work, operationSubmitter);
    }
}

