/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.GenericPayload;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.Messages;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.Targeted;
import io.smallrye.reactive.messaging.TargetedMessages;
import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import io.smallrye.reactive.messaging.providers.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.providers.extension.HealthCenter;
import io.smallrye.reactive.messaging.providers.helpers.BroadcastHelper;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.ConverterUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;

public abstract class AbstractMediator {
    protected final MediatorConfiguration configuration;
    private final Function<Message<?>, Object[]> methodArgumentMapper;
    protected WorkerPoolRegistry workerPoolRegistry;
    private Invoker invoker;
    private Instance<PublisherDecorator> decorators;
    private Instance<SubscriberDecorator> subscriberDecorators;
    protected HealthCenter health;
    private Instance<MessageConverter> converters;
    private Instance<KeyValueExtractor> extractors;
    private int maxConcurrency;

    /*
     * Exception decompiling
     */
    public AbstractMediator(MediatorConfiguration configuration) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setDecorators(Instance<PublisherDecorator> decorators) {
        this.decorators = decorators;
    }

    public void setSubscriberDecorators(Instance<SubscriberDecorator> decorators) {
        this.subscriberDecorators = decorators;
    }

    public void setConverters(Instance<MessageConverter> converters) {
        this.converters = converters;
    }

    public void setExtractors(Instance<KeyValueExtractor> extractors) {
        this.extractors = extractors;
    }

    public void setWorkerPoolRegistry(WorkerPoolRegistry workerPoolRegistry) {
        this.workerPoolRegistry = workerPoolRegistry;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void run() {
    }

    public void connectToUpstream(Multi<? extends Message<?>> publisher) {
    }

    public MediatorConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object bean) {
        AbstractMediator abstractMediator = this;
        synchronized (abstractMediator) {
            if (this.invoker == null) {
                this.invoker = args -> {
                    try {
                        return this.configuration.getMethod().invoke(bean, args);
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().equals("argument type mismatch")) {
                            throw ProviderExceptions.ex.illegalArgumentParameters(this.configuration.methodAsString(), String.join((CharSequence)",", (CharSequence[])Arrays.stream(this.configuration.getMethod().getParameterTypes()).map(Class::getSimpleName).toArray(String[]::new)), String.join((CharSequence)",", (CharSequence[])Arrays.stream(args).map(c -> c.getClass().getSimpleName()).toArray(String[]::new)));
                        }
                        throw ProviderExceptions.ex.processingException(this.configuration.methodAsString(), e);
                    }
                    catch (Exception e) {
                        throw ProviderExceptions.ex.processingException(this.configuration.methodAsString(), e);
                    }
                };
            }
        }
        Objects.requireNonNull(this.invoker, ProviderMessages.msg.invokerNotInitialized());
        if (this.configuration.isBlocking()) {
            Objects.requireNonNull(this.workerPoolRegistry, ProviderMessages.msg.workerPoolNotInitialized());
        }
    }

    protected <T> T invoke(Object ... args) {
        try {
            return (T)this.invoker.invoke(args);
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected <T> Uni<T> invokeOnMessageContext(Message<?> message, Object ... args) {
        return LocalContextMetadata.invokeOnMessageContext(message, x -> this.invoke(args));
    }

    protected <T> Object[] getArguments(Message<T> message) {
        if (this.methodArgumentMapper != null) {
            return this.methodArgumentMapper.apply(message);
        }
        throw new IllegalArgumentException("Unable to use the argument mapper for method " + this.configuration.methodAsString() + ", only methods consuming messages or payloads are supported");
    }

    protected <T> Uni<T> invokeBlocking(Message<?> message, Object ... args) {
        try {
            Optional metadata = message != null ? message.getMetadata().get(LocalContextMetadata.class) : Optional.empty();
            io.vertx.mutiny.core.Context currentContext = metadata.map(m -> io.vertx.mutiny.core.Context.newInstance((Context)m.context())).orElseGet(Vertx::currentContext);
            return this.workerPoolRegistry.executeWork(currentContext, Uni.createFrom().deferred(() -> {
                try {
                    Object result = this.invoker.invoke(args);
                    if (result instanceof CompletionStage) {
                        return Uni.createFrom().completionStage((CompletionStage)result);
                    }
                    if (result instanceof Uni) {
                        return (Uni)result;
                    }
                    return Uni.createFrom().item(result);
                }
                catch (RuntimeException e) {
                    ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
                    return Uni.createFrom().failure((Throwable)e);
                }
            }), this.configuration.getWorkerPoolName(), this.configuration.isBlockingExecutionOrdered());
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected CompletionStage<Message<?>> getAckOrCompletion(Message<?> message) {
        CompletionStage ack = message.ack();
        if (ack != null) {
            return ack.thenApply(x -> message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public Multi<? extends Message<?>> getStream() {
        return null;
    }

    public Multi<? extends Message<?>> getStream(String outgoing) {
        if (this.configuration.hasTargetedOutput()) {
            return this.getStream().onItem().transformToUniAndConcatenate(message -> this.extractTargetedMessage(outgoing, (Message<?>)message));
        }
        return this.getStream();
    }

    public MediatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMethodAsString() {
        return this.configuration.methodAsString();
    }

    public Flow.Subscriber<Message<?>> getComputedSubscriber() {
        return null;
    }

    public abstract boolean isConnected();

    protected Function<Message<?>, ? extends CompletionStage<? extends Message<?>>> managePreProcessingAck() {
        return this::handlePreProcessingAck;
    }

    protected CompletionStage<Message<?>> handlePreProcessingAck(Message<?> message) {
        if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.PRE_PROCESSING) {
            return this.getAckOrCompletion(message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> input) {
        if (input == null) {
            return null;
        }
        for (PublisherDecorator decorator : CDIUtils.getSortedInstances(this.decorators)) {
            input = decorator.decorate(input, this.getConfiguration().getOutgoings(), false);
        }
        if (this.getBroadcast()) {
            if (this.configuration.hasTargetedOutput() && !this.configuration.production().isMessageType()) {
                input = input.map(s -> {
                    TargetedMessages messages = TargetedMessages.from((Targeted)((Targeted)s.getPayload()));
                    return Messages.chain((Message)s).with((Map)messages.getPayload());
                });
            }
            return BroadcastHelper.broadcastPublisher(input, this.getNumberOfSubscriberBeforeConnecting());
        }
        return input;
    }

    boolean getBroadcast() {
        return this.configuration.getBroadcast() || this.configuration.getOutgoings().size() > 1;
    }

    int getNumberOfSubscriberBeforeConnecting() {
        int outgoings = this.configuration.getOutgoings().size();
        if (outgoings > 1) {
            return outgoings;
        }
        return this.configuration.getNumberOfSubscriberBeforeConnecting();
    }

    public Multi<? extends Message<?>> decorateSubscriberSource(Multi<? extends Message<?>> input) {
        if (input == null) {
            return null;
        }
        for (SubscriberDecorator decorator : CDIUtils.getSortedInstances(this.subscriberDecorators)) {
            input = decorator.decorate(input, this.configuration.getIncoming(), false);
        }
        return input;
    }

    public void setHealth(HealthCenter health) {
        this.health = health;
    }

    public Multi<? extends Message<?>> convert(Multi<? extends Message<?>> upstream) {
        return ConverterUtils.convert(upstream, this.converters, this.configuration.getIngestedPayloadType());
    }

    public Instance<KeyValueExtractor> extractors() {
        return this.extractors;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public void terminate() {
    }

    protected Uni<? extends Message<?>> extractTargetedMessage(String outgoing, Message<?> message) {
        if (message instanceof TargetedMessages) {
            Message msg = ((TargetedMessages)message).get(outgoing);
            return Uni.createFrom().item((Object)msg);
        }
        return Uni.createFrom().item(message);
    }

    protected Message<Object> payloadToMessage(Object payload) {
        return payload instanceof GenericPayload ? ((GenericPayload)payload).toMessage() : Message.of((Object)payload);
    }

    private static /* synthetic */ Object[] lambda$new$8(Function[] extractors, Message msg) {
        return Arrays.stream(extractors).map(extractor -> extractor.apply(msg)).toArray(Object[]::new);
    }

    private static /* synthetic */ Object lambda$new$5(Class type, Message msg) {
        return msg.getMetadata().get(type).orElse(null);
    }

    private static /* synthetic */ Object lambda$new$4(Class type, Message msg) {
        return msg.getMetadata(type).orElse(null);
    }

    private static /* synthetic */ Object lambda$new$3(Class c, Message msg) {
        return msg.getMetadata().get(c);
    }

    private static /* synthetic */ Object lambda$new$2(Class c, Message msg) {
        return msg.getMetadata(c);
    }

    private static /* synthetic */ Object[] lambda$new$1(Message msg) {
        return new Object[]{msg.getPayload()};
    }
}

