/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.appclient.subsystem.AppClientExtension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

class AppClientServerConfiguration {
    private AppClientServerConfiguration() {
    }

    public static List<ModelNode> serverConfiguration(String filePath, String deploymentName, String hostUrl, String propertiesFileUrl, List<String> parameters, List<ModelNode> xmlNodes) {
        ArrayList<ModelNode> ret = new ArrayList<ModelNode>();
        for (ModelNode node : xmlNodes) {
            ret.add(node);
        }
        AppClientServerConfiguration.appclient(ret, filePath, deploymentName, hostUrl, propertiesFileUrl, parameters);
        return ret;
    }

    private static void appclient(List<ModelNode> nodes, String filePath, String deploymentName, String hostUrl, String propertiesFileUrl, List<String> parameters) {
        AppClientServerConfiguration.loadExtension(nodes, "org.jboss.as.appclient");
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{AppClientExtension.SUBSYSTEM_PATH}));
        add.get("file").set(filePath);
        if (deploymentName != null) {
            add.get("deployment").set(deploymentName);
        }
        if (parameters.isEmpty()) {
            add.get("parameters").setEmptyList();
        } else {
            for (String param : parameters) {
                add.get("parameters").add(param);
            }
        }
        if (hostUrl != null) {
            add.get("host-url").set(hostUrl);
        }
        if (propertiesFileUrl != null) {
            add.get("connection-properties-url").set(propertiesFileUrl);
        }
        nodes.add(add);
    }

    private static void loadExtension(List<ModelNode> nodes, String moduleName) {
        ModelNode add = new ModelNode();
        add.get("address").set(new ModelNode().setEmptyList()).add("extension", moduleName);
        add.get("operation").set("add");
        nodes.add(add);
    }
}

