/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;

public class DefaultNotificationDescriptionProvider
implements DescriptionProvider {
    private final String notificationType;
    private final Stability stability;
    private final ResourceDescriptionResolver descriptionResolver;
    private final NotificationDefinition.DataValueDescriptor dataValueDescriptor;

    public DefaultNotificationDescriptionProvider(NotificationDefinition definition, ResourceDescriptionResolver descriptionResolver, NotificationDefinition.DataValueDescriptor dataValueDescriptor) {
        this.notificationType = definition.getType();
        this.stability = definition.getStability();
        this.descriptionResolver = descriptionResolver;
        this.dataValueDescriptor = dataValueDescriptor;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode dataDescription;
        ModelNode result = new ModelNode();
        ResourceBundle bundle = this.descriptionResolver.getResourceBundle(locale);
        result.get("notification-type").set(this.notificationType);
        result.get("description").set(this.descriptionResolver.getNotificationDescription(this.notificationType, locale, bundle));
        if (this.dataValueDescriptor != null && (dataDescription = this.dataValueDescriptor.describe(bundle)) != null && dataDescription.isDefined()) {
            result.get("data-type").set(dataDescription);
        }
        result.get("stability").set(this.stability.toString());
        return result;
    }
}

