/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentPersister;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.AgentClusterLinkContext;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

abstract class AbstractAgentClusterLink<R>
implements ToStringTreeAppendable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final FailureHandler failureHandler;
    protected final Clock clock;
    protected final Duration pollingInterval;
    protected final Duration pulseInterval;
    protected final Duration pulseExpiration;
    private final AgentPersister agentPersister;

    public AbstractAgentClusterLink(AgentPersister agentPersister, FailureHandler failureHandler, Clock clock, Duration pollingInterval, Duration pulseInterval, Duration pulseExpiration) {
        this.agentPersister = agentPersister;
        this.failureHandler = failureHandler;
        this.clock = clock;
        this.pollingInterval = pollingInterval;
        this.pulseInterval = pulseInterval;
        this.pulseExpiration = pulseExpiration;
    }

    public String toString() {
        return this.toStringTree();
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("agentPersister", (Object)this.agentPersister).attribute("pollingInterval", (Object)this.pollingInterval).attribute("pulseInterval", (Object)this.pulseInterval).attribute("pulseExpiration", (Object)this.pulseExpiration);
    }

    public final R pulse(AgentClusterLinkContext context) {
        Agent self = this.ensureRegistered(context);
        List<Agent> allAgentsInIdOrder = context.agentRepository().findAllOrderById();
        Instant now = this.clock.instant();
        log.tracef("Agent '%s': starting pulse at %s with self = %s, all agents = %s", new Object[]{this.selfReference(), now, self, allAgentsInIdOrder});
        Instant expirationLimit = now;
        List<Agent> timedOutAgents = allAgentsInIdOrder.stream().filter(Predicate.isEqual(self).negate()).filter(a -> a.getExpiration().isBefore(expirationLimit)).collect(Collectors.toList());
        if (!timedOutAgents.isEmpty()) {
            log.removingTimedOutAgents(this.selfReference(), timedOutAgents);
            context.agentRepository().delete(timedOutAgents);
            log.infof("Agent '%s': reassessing the new situation in the next pulse", this.selfReference());
            return this.instructCommitAndRetryPulseAfterDelay(now, this.pollingInterval);
        }
        WriteAction<R> pulseResult = this.doPulse(allAgentsInIdOrder, self);
        context.commitAndBeginNewTransaction();
        now = this.clock.instant();
        self = this.findSelfExpectRegistered(context);
        self.setExpiration(now.plus(this.pulseExpiration));
        R instructions = pulseResult.applyAndReturnInstructions(now, self, this.agentPersister);
        log.tracef("Agent '%s': ending pulse at %s with self = %s", this.selfReference(), now, self);
        return instructions;
    }

    private Agent ensureRegistered(AgentClusterLinkContext context) {
        Agent self = this.agentPersister.findSelf(context.agentRepository());
        if (self == null) {
            Instant now = this.clock.instant();
            this.agentPersister.createSelf(context.agentRepository(), now.plus(this.pulseExpiration));
            context.commitAndBeginNewTransaction();
            self = this.findSelfExpectRegistered(context);
        }
        return self;
    }

    private Agent findSelfExpectRegistered(AgentClusterLinkContext context) {
        Agent self = this.agentPersister.findSelf(context.agentRepository());
        if (self == null) {
            throw log.agentRegistrationIneffective(this.selfReference());
        }
        return self;
    }

    protected abstract WriteAction<R> doPulse(List<Agent> var1, Agent var2);

    protected abstract R instructCommitAndRetryPulseAfterDelay(Instant var1, Duration var2);

    public final void leaveCluster(AgentClusterLinkContext context) {
        this.agentPersister.leaveCluster(context.agentRepository());
    }

    protected AgentReference selfReference() {
        return this.agentPersister.selfReference();
    }

    final AgentPersister getAgentPersisterForTests() {
        return this.agentPersister;
    }

    protected static interface WriteAction<R> {
        public R applyAndReturnInstructions(Instant var1, Agent var2, AgentPersister var3);
    }
}

