/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import jakarta.persistence.PersistenceException;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.JaxbEntityMappingsFormatter;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=850000, max=859999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET = 850000;

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850001, value="Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s")
    public void outboxEventGeneratedEntityMapping(@FormatWith(value=JaxbEntityMappingsFormatter.class) JaxbEntityMappings var1);

    @Message(id=850003, value="Max '%1$s' retries exhausted to process the event. Event will be aborted.")
    public SearchException maxRetryExhausted(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850004, value="Background indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Attempts so far: %4$d. The event will be reprocessed after the moment: %5$s.")
    public void backgroundIndexingRetry(UUID var1, String var2, String var3, int var4, Instant var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850005, value="Starting outbox event processor '%1$s': %2$s")
    public void startingOutboxEventProcessor(String var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) ToStringTreeAppendable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850006, value="Stopping outbox event processor '%1$s'")
    public void stoppingOutboxEventProcessor(String var1);

    @Message(id=850007, value="The total shard count must be strictly positive.")
    public SearchException invalidTotalShardCount();

    @Message(id=850008, value="Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').")
    public SearchException invalidShardIndex(int var1, String var2);

    @Message(id=850009, value="This property must be set when '%s' is set.")
    public SearchException missingPropertyForStaticSharding(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850010, value="The outbox event processor is disabled for tenant '%s'.  Events will accumulate in the outbox table and indexes will not be updated, unless another application node connects to the same database with their event processor enabled.")
    public void eventProcessorDisabled(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850011, value="'%1$s' failed to obtain a lock on events to update/delete; will try again later.")
    public void outboxEventProcessorUnableToLock(String var1, @Cause PersistenceException var2);

    @Message(id=850012, value="Unable to serialize OutboxEvent payload with Avro: %1$s")
    public SearchException unableToSerializeOutboxEventPayloadWithAvro(String var1, @Cause Throwable var2);

    @Message(id=850013, value="Unable to deserialize OutboxEvent payload with Avro: %1$s")
    public SearchException unableToDeserializeOutboxEventPayloadWithAvro(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850014, value="Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s")
    public void agentGeneratedEntityMapping(@FormatWith(value=JaxbEntityMappingsFormatter.class) JaxbEntityMappings var1);

    @Message(id=850015, value="The pulse interval must be greater than or equal to the polling interval i.e. in this case at least %s")
    public SearchException invalidPollingIntervalAndPulseInterval(long var1);

    @Message(id=850016, value="The pulse expiration must be greater than or equal to 3 times the pulse interval i.e. in this case at least %s")
    public SearchException invalidPulseIntervalAndPulseExpiration(long var1);

    @Message(value="Pulse operation for agent '%1$s'")
    public String outboxEventProcessorPulse(AgentReference var1);

    @Message(id=850017, value="Agent '%1$s': failed to infer a target cluster from the list of registered agents. The agent will try again in the next pulse. Cause: %2$s Registered agents: %3$s.")
    public SearchException outboxEventProcessorPulseFailed(AgentReference var1, String var2, List<Agent> var3, @Cause RuntimeException var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850018, value="Agent '%1$s': the registration of some agents in the outbox-polling strategy are considered expired and will be forcibly removed: %2$s. These agents did not update their registration in the database in time. This can be caused by invalid configuration (expiration lower than how long it takes to process a batch of events) or by an application node being forcibly stopped (disconnection from the network, application crash).")
    public void removingTimedOutAgents(AgentReference var1, List<Agent> var2);

    @Message(id=850019, value="Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which expects %4$s shards. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and expecting a different amount of shards; consider adjusting the configuration or switching to dynamic sharding.")
    public SearchException conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(AgentReference var1, ShardAssignmentDescriptor var2, AgentReference var3, int var4);

    @Message(id=850020, value="Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which is also assigned to that shard. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and being assigned to the same shard; consider adjusting the configuration or switching to dynamic sharding.")
    public SearchException conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(AgentReference var1, ShardAssignmentDescriptor var2, AgentReference var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850021, value="Starting outbox mass indexer agent '%1$s': %2$s")
    public void startingOutboxMassIndexerAgent(String var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) ToStringTreeAppendable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850022, value="Stopping outbox mass indexer agent '%1$s'")
    public void stoppingOutboxMassIndexerAgent(String var1);

    @Message(id=850023, value="Invalid target for Outbox Polling extension: '%1$s'. This extension can only be applied when Hibernate Search is configured to use the 'outbox-polling' coordination strategy.")
    public SearchException outboxPollingExtensionOnUnknownType(Object var1);

    @Message(id=850024, value="Multi-tenancy is enabled but no tenant id is specified. Available tenants are: '%1$s'.")
    public SearchException noTenantIdSpecified(Set<String> var1);

    @Message(id=850025, value="Multi-tenancy is not enabled but a tenant id is specified. Trying to use the tenant id: '%1$s'.")
    public SearchException multiTenancyNotEnabled(String var1);

    @Message(id=850026, value="Outbox polling agent configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.")
    public SearchException agentConfigurationPropertyConflict(String var1, String[] var2);

    @Message(id=850027, value="Outbox event configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.")
    public SearchException outboxEventConfigurationPropertyConflict(String var1, String[] var2);

    @Message(id=850028, value="Agent '%1$s': could not find the agent after starting a new transaction. The agent was present just a moment ago. Either this problem is a rare occurrence, or the pulse expiration delay is too short.")
    public SearchException agentRegistrationIneffective(AgentReference var1);

    @Message(id=850029, value="Nonblocking operation submitter is not supported.")
    public SearchException nonblockingOperationSubmitterNotSupported();

    @Message(id=850030, value="Invalid name for the UUID generation strategy: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidUuidGenerationStrategyName(String var1, List<String> var2);

    @Message(id=850031, value="Invalid name for the outbox event processing order: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidOutboxEventProcessingOrderName(String var1, List<String> var2);

    @Message(id=850032, value="Invalid name for the payload type: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidPayloadTypeName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850034, value="'%1$s' failed to retrieve events to process due to a locking failure; will try again later.")
    public void eventProcessorFindEventsUnableToLock(String var1, @Cause PersistenceException var2);

    @Message(id=850035, value="Unable to process provided entity mappings: %1$s")
    public SearchException unableToProcessEntityMappings(String var1, @Cause Exception var2);

    @Message(id=850036, value="Unable to parse '%1$s' as a JDBC type code or type code name. %2$s")
    public SearchException unableToParseJdbcTypeCode(String var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850037, value="Configuration property '%1$s' is configured with a deprecated value '%2$s'. Use '%3$s' instead.")
    public void usingDeprecatedPropertyValue(String var1, String var2, String var3);
}

