/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.runtime.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class ReusableStreams {
    private final ReusableByteArrayDataInputStream dataInput = new ReusableByteArrayDataInputStream(new ReplaceableByteArrayInputStream(new byte[0], 0, 0));

    public DataInputStream getDataInputStream(byte[] buf, int offset, int length) {
        this.dataInput.setByteInput(buf, offset, length);
        return this.dataInput;
    }

    private static class ReplaceableByteArrayInputStream
    extends InputStream {
        protected byte[] buf;
        protected int pos;
        protected int count;

        public ReplaceableByteArrayInputStream(byte[] buf, int offset, int length) {
            this.buf = buf;
            this.pos = offset;
            this.count = Math.min(offset + length, buf.length);
        }

        void setByteInput(byte[] buf, int offset, int length) {
            this.buf = buf;
            this.pos = offset;
            this.count = Math.min(offset + length, buf.length);
        }

        @Override
        public synchronized int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            Objects.checkFromIndexSize(off, len, b.length);
            if (this.pos >= this.count) {
                return -1;
            }
            int avail = this.count - this.pos;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        @Override
        public synchronized byte[] readAllBytes() {
            byte[] result = Arrays.copyOfRange(this.buf, this.pos, this.count);
            this.pos = this.count;
            return result;
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) {
            int n = this.read(b, off, len);
            return n == -1 ? 0 : n;
        }

        @Override
        public synchronized long transferTo(OutputStream out) throws IOException {
            int len = this.count - this.pos;
            out.write(this.buf, this.pos, len);
            this.pos = this.count;
            return len;
        }

        @Override
        public synchronized long skip(long n) {
            long k = this.count - this.pos;
            if (n < k) {
                k = n < 0L ? 0L : n;
            }
            this.pos = (int)((long)this.pos + k);
            return k;
        }

        @Override
        public synchronized int available() {
            return this.count - this.pos;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readAheadLimit) {
            throw new IllegalStateException();
        }

        @Override
        public synchronized void reset() {
            this.pos = 0;
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class ReusableByteArrayDataInputStream
    extends DataInputStream {
        private final ReplaceableByteArrayInputStream byteInput;

        private ReusableByteArrayDataInputStream(ReplaceableByteArrayInputStream in) {
            super(in);
            this.byteInput = in;
        }

        public void setByteInput(byte[] buf, int offset, int length) {
            this.byteInput.setByteInput(buf, offset, length);
        }

        @Override
        public void close() throws IOException {
            this.byteInput.buf = null;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

