/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.BaseStream;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheStream;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.CacheFilters;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.BaseEmbeddedQuery;
import org.infinispan.query.core.impl.ExternalizerIds;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;

public final class EmbeddedQuery<T>
extends BaseEmbeddedQuery<T> {
    private final QueryEngine<?> queryEngine;
    private IckleFilterAndConverter<?, ?> filter;
    private final int defaultMaxResults;

    public EmbeddedQuery(QueryEngine<?> queryEngine, QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, int defaultMaxResults, LocalQueryStatistics queryStatistics, boolean local) {
        super(queryFactory, cache, queryString, statementType, namedParameters, projection, startOffset, maxResults, queryStatistics, local);
        this.queryEngine = queryEngine;
        this.defaultMaxResults = defaultMaxResults;
        if (maxResults == -1) {
            this.maxResults = defaultMaxResults;
        }
    }

    @Override
    public void resetQuery() {
        super.resetQuery();
        this.filter = null;
    }

    @Override
    protected void recordQuery(long time) {
        this.queryStatistics.nonIndexedQueryExecuted(this.queryString, time);
    }

    private IckleFilterAndConverter<?, ?> createFilter() {
        if (this.filter == null) {
            this.filter = this.queryEngine.createAndWireFilter(this.queryString, this.namedParameters);
            this.filter.getObjectFilter();
        }
        return this.filter;
    }

    @Override
    protected Comparator<Comparable<?>[]> getComparator() {
        return this.createFilter().getObjectFilter().getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getInternalIterator() {
        IckleFilterAndConverter<?, ?> ickleFilter = this.createFilter();
        AdvancedCache cache = this.isLocal() ? this.cache.withFlags(Flag.CACHE_MODE_LOCAL) : this.cache;
        CacheStream entryStream = cache.cacheEntrySet().stream();
        if (this.timeout > 0L) {
            entryStream = entryStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        CacheStream resultStream = CacheFilters.filterAndConvertToValue((CacheStream)entryStream, ickleFilter);
        if (this.timeout > 0L) {
            resultStream = resultStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        return Closeables.iterator((BaseStream)resultStream);
    }

    @Override
    public QueryResult<T> execute() {
        if (this.isSelectStatement()) {
            return super.execute();
        }
        return new QueryResultImpl(this.executeStatement(), Collections.emptyList());
    }

    public int executeStatement() {
        if (this.isSelectStatement()) {
            throw Log.CONTAINER.unsupportedStatement();
        }
        if (this.getStartOffset() != 0L || this.getMaxResults() != this.defaultMaxResults) {
            throw Log.CONTAINER.deleteStatementsCannotUsePaging();
        }
        IckleFilterAndConverter<?, ?> ickleFilter = this.createFilter();
        AdvancedCache cache = this.isLocal() ? this.cache.withFlags(Flag.CACHE_MODE_LOCAL) : this.cache;
        CacheStream entryStream = cache.cacheEntrySet().stream();
        if (this.timeout > 0L) {
            entryStream = entryStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        CacheStream filteredKeyStream = CacheFilters.filterAndConvertToKey((CacheStream)entryStream, ickleFilter);
        if (this.timeout > 0L) {
            filteredKeyStream = filteredKeyStream.timeout(this.timeout, TimeUnit.NANOSECONDS);
        }
        Optional count = filteredKeyStream.map((Function)new DeleteFunction()).reduce(Integer::sum);
        filteredKeyStream.close();
        return count.orElse(0);
    }

    @Override
    public String toString() {
        return "EmbeddedQuery{queryString=" + this.queryString + ", statementType=" + String.valueOf(this.statementType) + ", namedParameters=" + String.valueOf(this.namedParameters) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", defaultMaxResults=" + this.defaultMaxResults + ", timeout=" + this.timeout + "}";
    }

    @Scope(value=Scopes.NONE)
    static final class DeleteFunction
    implements Function<Object, Integer> {
        @Inject
        AdvancedCache<?, ?> cache;

        DeleteFunction() {
        }

        @Override
        public Integer apply(Object key) {
            key = this.cache.getKeyDataConversion().fromStorage(key);
            return this.cache.remove(key) == null ? 0 : 1;
        }
    }

    public static final class DeleteFunctionExternalizer
    implements AdvancedExternalizer<DeleteFunction> {
        public void writeObject(ObjectOutput output, DeleteFunction object) {
        }

        public DeleteFunction readObject(ObjectInput input) {
            return new DeleteFunction();
        }

        public Set<Class<? extends DeleteFunction>> getTypeClasses() {
            return Collections.singleton(DeleteFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_DELETE_FUNCTION;
        }
    }
}

